/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class MultiValueMap
extends AbstractMapDecorator
implements MultiMap {
    private final Factory collectionFactory;
    private transient Collection values;
    static Class class$java$util$ArrayList;

    public static MultiValueMap decorate(Map map) {
        return new MultiValueMap(map, new ReflectionFactory(class$java$util$ArrayList == null ? (class$java$util$ArrayList = MultiValueMap.class$("java.util.ArrayList")) : class$java$util$ArrayList));
    }

    public static MultiValueMap decorate(Map map, Class collectionClass) {
        return new MultiValueMap(map, new ReflectionFactory(collectionClass));
    }

    public static MultiValueMap decorate(Map map, Factory collectionFactory) {
        return new MultiValueMap(map, collectionFactory);
    }

    public MultiValueMap() {
        this(new HashMap(), new ReflectionFactory(class$java$util$ArrayList == null ? (class$java$util$ArrayList = MultiValueMap.class$("java.util.ArrayList")) : class$java$util$ArrayList));
    }

    protected MultiValueMap(Map map, Factory collectionFactory) {
        super(map);
        if (collectionFactory == null) {
            throw new IllegalArgumentException("The factory must not be null");
        }
        this.collectionFactory = collectionFactory;
    }

    public void clear() {
        this.getMap().clear();
    }

    public Object remove(Object key, Object value) {
        Collection collection = this.getCollection(key);
        if (collection == null) {
            return null;
        }
        boolean bl = collection.remove(value);
        if (!bl) {
            return null;
        }
        if (collection.isEmpty()) {
            this.remove(key);
        }
        return value;
    }

    public boolean containsValue(Object value) {
        Set set = this.getMap().entrySet();
        if (set == null) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Collection collection = (Collection)entry.getValue();
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    public Object put(Object key, Object value) {
        boolean result;
        Collection collection = this.getCollection(key);
        if (collection == null) {
            collection = this.createCollection(1);
            result = collection.add(value);
            if (collection.size() > 0) {
                this.getMap().put(key, collection);
                result = true;
            }
        } else {
            result = collection.add(value);
        }
        if (result) {
            return value;
        }
        return null;
    }

    public void putAll(Map map) {
        if (map instanceof MultiMap) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Collection collection = (Collection)entry.getValue();
                this.putAll(entry.getKey(), collection);
            }
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Collection values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values(this, null);
        return this.values;
    }

    public boolean containsValue(Object key, Object value) {
        Collection collection = this.getCollection(key);
        if (collection == null) {
            return false;
        }
        return collection.contains(value);
    }

    public Collection getCollection(Object key) {
        return (Collection)this.getMap().get(key);
    }

    public int size(Object key) {
        Collection collection = this.getCollection(key);
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public boolean putAll(Object key, Collection values) {
        if (values == null || values.size() == 0) {
            return false;
        }
        boolean bl = false;
        Collection collection = this.getCollection(key);
        if (collection == null) {
            collection = this.createCollection(values.size());
            collection.addAll(values);
            if (collection.size() > 0) {
                this.getMap().put(key, collection);
                bl = true;
            }
        } else {
            bl = collection.addAll(values);
        }
        return bl;
    }

    public Iterator iterator(Object key) {
        if (!this.containsKey(key)) {
            return EmptyIterator.INSTANCE;
        }
        return new ValuesIterator(this, key);
    }

    public int totalSize() {
        int n2 = 0;
        Collection collection = this.getMap().values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Collection collection2 = (Collection)iterator.next();
            n2 += collection2.size();
        }
        return n2;
    }

    protected Collection createCollection(int size) {
        return (Collection)this.collectionFactory.create();
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class 1 {
    }

    private static class ReflectionFactory
    implements Factory {
        private final Class clazz;

        public ReflectionFactory(Class clazz) {
            this.clazz = clazz;
        }

        public Object create() {
            try {
                return this.clazz.newInstance();
            }
            catch (Exception exception) {
                throw new FunctorException("Cannot instantiate class: " + this.clazz, exception);
            }
        }
    }

    private class ValuesIterator
    implements Iterator {
        private final Object key;
        private final Collection values;
        private final Iterator iterator;
        private final MultiValueMap this$0;

        public ValuesIterator(MultiValueMap multiValueMap, Object key) {
            this.this$0 = multiValueMap;
            this.key = key;
            this.values = multiValueMap.getCollection(key);
            this.iterator = this.values.iterator();
        }

        public void remove() {
            this.iterator.remove();
            if (this.values.isEmpty()) {
                this.this$0.remove(this.key);
            }
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }
    }

    private class Values
    extends AbstractCollection {
        private final MultiValueMap this$0;

        private Values(MultiValueMap multiValueMap) {
            this.this$0 = multiValueMap;
        }

        public Iterator iterator() {
            IteratorChain iteratorChain = new IteratorChain();
            Iterator iterator = this.this$0.keySet().iterator();
            while (iterator.hasNext()) {
                iteratorChain.addIterator(new ValuesIterator(this.this$0, iterator.next()));
            }
            return iteratorChain;
        }

        public int size() {
            return this.this$0.totalSize();
        }

        public void clear() {
            this.this$0.clear();
        }

        Values(MultiValueMap x0, 1 x1) {
            this(x0);
        }
    }
}

