/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.Validate;

final class CharRange
implements Serializable,
Iterable<Character> {
    private static final long serialVersionUID = 8270183163158333422L;
    private final char start;
    private final char end;
    private final boolean negated;
    private transient String iToString;

    private CharRange(char start, char end, boolean negated) {
        if (start > end) {
            char c2 = start;
            start = end;
            end = c2;
        }
        this.start = start;
        this.end = end;
        this.negated = negated;
    }

    public static CharRange is(char ch) {
        char c2 = ch;
        return new CharRange(c2, c2, false);
    }

    public static CharRange isNot(char ch) {
        char c2 = ch;
        return new CharRange(c2, c2, true);
    }

    public static CharRange isIn(char start, char end) {
        return new CharRange(start, end, false);
    }

    public static CharRange isNotIn(char start, char end) {
        return new CharRange(start, end, true);
    }

    public final char getStart() {
        return this.start;
    }

    public final char getEnd() {
        return this.end;
    }

    public final boolean isNegated() {
        return this.negated;
    }

    public final boolean contains(char ch) {
        return (ch >= this.start && ch <= this.end) != this.negated;
    }

    public final boolean contains(CharRange range) {
        Validate.isTrue(range != null, "The Range must not be null", new Object[0]);
        if (this.negated) {
            if (range.negated) {
                return this.start >= range.start && this.end <= range.end;
            }
            return range.end < this.start || range.start > this.end;
        }
        if (range.negated) {
            return this.start == '\u0000' && this.end == '\uffff';
        }
        return this.start <= range.start && this.end >= range.end;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharRange)) {
            return false;
        }
        CharRange charRange = (CharRange)obj;
        return this.start == charRange.start && this.end == charRange.end && this.negated == charRange.negated;
    }

    public final int hashCode() {
        return 83 + this.start + 7 * this.end + (this.negated ? 1 : 0);
    }

    public final String toString() {
        if (this.iToString == null) {
            StringBuilder stringBuilder = new StringBuilder(4);
            if (this.isNegated()) {
                stringBuilder.append('^');
            }
            stringBuilder.append(this.start);
            if (this.start != this.end) {
                stringBuilder.append('-');
                stringBuilder.append(this.end);
            }
            this.iToString = stringBuilder.toString();
        }
        return this.iToString;
    }

    @Override
    public final Iterator<Character> iterator() {
        return new CharacterIterator(this);
    }

    private static class CharacterIterator
    implements Iterator<Character> {
        private char current;
        private final CharRange range;
        private boolean hasNext;

        private CharacterIterator(CharRange r2) {
            this.range = r2;
            this.hasNext = true;
            if (this.range.negated) {
                if (this.range.start == '\u0000') {
                    if (this.range.end == '\uffff') {
                        this.hasNext = false;
                        return;
                    }
                    this.current = (char)(this.range.end + '\u0001');
                    return;
                }
                this.current = '\u0000';
                return;
            }
            this.current = this.range.start;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void prepareNext() {
            if (this.range.negated) {
                if (this.current != '\uffff') {
                    if (this.current + '\u0001' != this.range.start) {
                        this.current = (char)(this.current + '\u0001');
                        return;
                    }
                    if (this.range.end != '\uffff') {
                        this.current = (char)(this.range.end + '\u0001');
                        return;
                    }
                }
            } else if (this.current < this.range.end) {
                this.current = (char)(this.current + '\u0001');
                return;
            }
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Character next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            char c2 = this.current;
            this.prepareNext();
            return Character.valueOf(c2);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

