/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

public class CharSequenceUtils {
    private static final int NOT_FOUND = -1;

    public static CharSequence subSequence(CharSequence cs, int start) {
        if (cs == null) {
            return null;
        }
        return cs.subSequence(start, cs.length());
    }

    static int indexOf(CharSequence cs, int searchChar, int start) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start);
        }
        int n2 = cs.length();
        if (start < 0) {
            start = 0;
        }
        if (searchChar < 65536) {
            for (int i2 = start; i2 < n2; ++i2) {
                if (cs.charAt(i2) != searchChar) continue;
                return i2;
            }
        }
        if (searchChar <= 0x10FFFF) {
            char[] cArray = Character.toChars(searchChar);
            for (int i3 = start; i3 < n2 - 1; ++i3) {
                char c2 = cs.charAt(i3);
                char c3 = cs.charAt(i3 + 1);
                if (c2 != cArray[0] || c3 != cArray[1]) continue;
                return i3;
            }
        }
        return -1;
    }

    static int indexOf(CharSequence cs, CharSequence searchChar, int start) {
        return cs.toString().indexOf(searchChar.toString(), start);
    }

    static int lastIndexOf(CharSequence cs, int searchChar, int start) {
        if (cs instanceof String) {
            return ((String)cs).lastIndexOf(searchChar, start);
        }
        int n2 = cs.length();
        if (start < 0) {
            return -1;
        }
        if (start >= n2) {
            start = n2 - 1;
        }
        if (searchChar < 65536) {
            for (int i2 = start; i2 >= 0; --i2) {
                if (cs.charAt(i2) != searchChar) continue;
                return i2;
            }
        }
        if (searchChar <= 0x10FFFF) {
            char[] cArray = Character.toChars(searchChar);
            if (start == n2 - 1) {
                return -1;
            }
            for (int i3 = start; i3 >= 0; --i3) {
                char c2 = cs.charAt(i3);
                char c3 = cs.charAt(i3 + 1);
                if (cArray[0] != c2 || cArray[1] != c3) continue;
                return i3;
            }
        }
        return -1;
    }

    static int lastIndexOf(CharSequence cs, CharSequence searchChar, int start) {
        return cs.toString().lastIndexOf(searchChar.toString(), start);
    }

    static char[] toCharArray(CharSequence cs) {
        if (cs instanceof String) {
            return ((String)cs).toCharArray();
        }
        int n2 = cs.length();
        char[] cArray = new char[cs.length()];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = cs.charAt(i2);
        }
        return cArray;
    }

    static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int n2 = thisStart;
        int n3 = start;
        int n4 = length;
        int n5 = cs.length() - thisStart;
        int n6 = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (n5 < length || n6 < length) {
            return false;
        }
        while (n4-- > 0) {
            char c2;
            char c3;
            if ((c3 = cs.charAt(n2++)) == (c2 = substring.charAt(n3++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c3) == Character.toUpperCase(c2) || Character.toLowerCase(c3) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }
}

