/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.Validate;

public class SerializationUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T clone(T object) {
        if (object == null) {
            return null;
        }
        byte[] byArray = SerializationUtils.serialize(object);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            Serializable serializable2;
            ClassLoaderAwareObjectInputStream classLoaderAwareObjectInputStream = new ClassLoaderAwareObjectInputStream(byteArrayInputStream, object.getClass().getClassLoader());
            Throwable throwable = null;
            try {
                Serializable serializable;
                serializable2 = serializable = (Serializable)classLoaderAwareObjectInputStream.readObject();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        classLoaderAwareObjectInputStream.close();
                        throw throwable4;
                    }
                    try {
                        classLoaderAwareObjectInputStream.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            classLoaderAwareObjectInputStream.close();
            return (T)serializable2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException("ClassNotFoundException while reading cloned object data", classNotFoundException);
        }
        catch (IOException iOException) {
            throw new SerializationException("IOException while reading or closing cloned object data", iOException);
        }
    }

    public static <T extends Serializable> T roundtrip(T msg) {
        return (T)((Serializable)SerializationUtils.deserialize(SerializationUtils.serialize(msg)));
    }

    public static void serialize(Serializable obj, OutputStream outputStream) {
        Validate.isTrue(outputStream != null, "The OutputStream must not be null", new Object[0]);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            Throwable throwable = null;
            try {
                objectOutputStream.writeObject(obj);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            objectOutputStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        objectOutputStream.close();
                    }
                    throw throwable4;
                }
            }
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    public static byte[] serialize(Serializable obj) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(obj, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(InputStream inputStream) {
        Validate.isTrue(inputStream != null, "The InputStream must not be null", new Object[0]);
        try {
            Object object2;
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Throwable throwable = null;
            try {
                Object object;
                object2 = object = objectInputStream.readObject();
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        objectInputStream.close();
                        throw throwable4;
                    }
                    try {
                        objectInputStream.close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        throw throwable4;
                    }
                }
            }
            objectInputStream.close();
            return (T)object2;
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new SerializationException(exception);
        }
    }

    public static <T> T deserialize(byte[] objectData) {
        Validate.isTrue(objectData != null, "The byte[] must not be null", new Object[0]);
        return SerializationUtils.deserialize(new ByteArrayInputStream(objectData));
    }

    static class ClassLoaderAwareObjectInputStream
    extends ObjectInputStream {
        private static final Map<String, Class<?>> primitiveTypes = new HashMap();
        private final ClassLoader classLoader;

        ClassLoaderAwareObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String string = desc.getName();
            try {
                return Class.forName(string, false, this.classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    return Class.forName(string, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    Class<?> clazz = primitiveTypes.get(string);
                    if (clazz != null) {
                        return clazz;
                    }
                    throw classNotFoundException2;
                }
            }
        }

        static {
            primitiveTypes.put("byte", Byte.TYPE);
            primitiveTypes.put("short", Short.TYPE);
            primitiveTypes.put("int", Integer.TYPE);
            primitiveTypes.put("long", Long.TYPE);
            primitiveTypes.put("float", Float.TYPE);
            primitiveTypes.put("double", Double.TYPE);
            primitiveTypes.put("boolean", Boolean.TYPE);
            primitiveTypes.put("char", Character.TYPE);
            primitiveTypes.put("void", Void.TYPE);
        }
    }
}

