/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.Validate;

public class ThreadUtils {
    public static final AlwaysTruePredicate ALWAYS_TRUE_PREDICATE = new AlwaysTruePredicate();

    public static Thread findThreadById(long threadId, ThreadGroup threadGroup) {
        Validate.isTrue(threadGroup != null, "The thread group must not be null", new Object[0]);
        Thread thread = ThreadUtils.findThreadById(threadId);
        if (thread != null && threadGroup.equals(thread.getThreadGroup())) {
            return thread;
        }
        return null;
    }

    public static Thread findThreadById(long threadId, String threadGroupName) {
        Validate.isTrue(threadGroupName != null, "The thread group name must not be null", new Object[0]);
        Thread thread = ThreadUtils.findThreadById(threadId);
        if (thread != null && thread.getThreadGroup() != null && thread.getThreadGroup().getName().equals(threadGroupName)) {
            return thread;
        }
        return null;
    }

    public static Collection<Thread> findThreadsByName(String threadName, ThreadGroup threadGroup) {
        return ThreadUtils.findThreads(threadGroup, false, new NamePredicate(threadName));
    }

    public static Collection<Thread> findThreadsByName(String threadName, String threadGroupName) {
        Validate.isTrue(threadName != null, "The thread name must not be null", new Object[0]);
        Validate.isTrue(threadGroupName != null, "The thread group name must not be null", new Object[0]);
        Collection<ThreadGroup> collection = ThreadUtils.findThreadGroups(new NamePredicate(threadGroupName));
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        NamePredicate namePredicate = new NamePredicate(threadName);
        for (ThreadGroup threadGroup : collection) {
            arrayList.addAll(ThreadUtils.findThreads(threadGroup, false, namePredicate));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static Collection<ThreadGroup> findThreadGroupsByName(String threadGroupName) {
        return ThreadUtils.findThreadGroups(new NamePredicate(threadGroupName));
    }

    public static Collection<ThreadGroup> getAllThreadGroups() {
        return ThreadUtils.findThreadGroups(ALWAYS_TRUE_PREDICATE);
    }

    public static ThreadGroup getSystemThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public static Collection<Thread> getAllThreads() {
        return ThreadUtils.findThreads(ALWAYS_TRUE_PREDICATE);
    }

    public static Collection<Thread> findThreadsByName(String threadName) {
        return ThreadUtils.findThreads(new NamePredicate(threadName));
    }

    public static Thread findThreadById(long threadId) {
        Collection<Thread> collection = ThreadUtils.findThreads(new ThreadIdPredicate(threadId));
        if (collection.isEmpty()) {
            return null;
        }
        return collection.iterator().next();
    }

    public static Collection<Thread> findThreads(ThreadPredicate predicate) {
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, predicate);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroupPredicate predicate) {
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, predicate);
    }

    public static Collection<Thread> findThreads(ThreadGroup group, boolean recurse, ThreadPredicate predicate) {
        int n2;
        Thread[] threadArray;
        Validate.isTrue(group != null, "The group must not be null", new Object[0]);
        Validate.isTrue(predicate != null, "The predicate must not be null", new Object[0]);
        int n3 = group.activeCount();
        do {
            n2 = n3;
        } while ((n3 = group.enumerate(threadArray = new Thread[n2 + n2 / 2 + 1], recurse)) >= threadArray.length);
        ArrayList<Thread> arrayList = new ArrayList<Thread>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!predicate.test(threadArray[i2])) continue;
            arrayList.add(threadArray[i2]);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup group, boolean recurse, ThreadGroupPredicate predicate) {
        int n2;
        ThreadGroup[] threadGroupArray;
        Validate.isTrue(group != null, "The group must not be null", new Object[0]);
        Validate.isTrue(predicate != null, "The predicate must not be null", new Object[0]);
        int n3 = group.activeGroupCount();
        do {
            n2 = n3;
        } while ((n3 = group.enumerate(threadGroupArray = new ThreadGroup[n2 + n2 / 2 + 1], recurse)) >= threadGroupArray.length);
        ArrayList<ThreadGroup> arrayList = new ArrayList<ThreadGroup>(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!predicate.test(threadGroupArray[i2])) continue;
            arrayList.add(threadGroupArray[i2]);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static class ThreadIdPredicate
    implements ThreadPredicate {
        private final long threadId;

        public ThreadIdPredicate(long threadId) {
            if (threadId <= 0L) {
                throw new IllegalArgumentException("The thread id must be greater than zero");
            }
            this.threadId = threadId;
        }

        @Override
        public boolean test(Thread thread) {
            return thread != null && thread.getId() == this.threadId;
        }
    }

    public static class NamePredicate
    implements ThreadGroupPredicate,
    ThreadPredicate {
        private final String name;

        public NamePredicate(String name) {
            Validate.isTrue(name != null, "The name must not be null", new Object[0]);
            this.name = name;
        }

        @Override
        public boolean test(ThreadGroup threadGroup) {
            return threadGroup != null && threadGroup.getName().equals(this.name);
        }

        @Override
        public boolean test(Thread thread) {
            return thread != null && thread.getName().equals(this.name);
        }
    }

    private static final class AlwaysTruePredicate
    implements ThreadGroupPredicate,
    ThreadPredicate {
        private AlwaysTruePredicate() {
        }

        @Override
        public final boolean test(ThreadGroup threadGroup) {
            return true;
        }

        @Override
        public final boolean test(Thread thread) {
            return true;
        }
    }

    public static interface ThreadGroupPredicate {
        public boolean test(ThreadGroup var1);
    }

    public static interface ThreadPredicate {
        public boolean test(Thread var1);
    }
}

