/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.math.BigInteger;
import org.apache.commons.lang3.Validate;

public final class Fraction
extends Number
implements Comparable<Fraction> {
    private static final long serialVersionUID = 65382027393090L;
    public static final Fraction ZERO = new Fraction(0, 1);
    public static final Fraction ONE = new Fraction(1, 1);
    public static final Fraction ONE_HALF = new Fraction(1, 2);
    public static final Fraction ONE_THIRD = new Fraction(1, 3);
    public static final Fraction TWO_THIRDS = new Fraction(2, 3);
    public static final Fraction ONE_QUARTER = new Fraction(1, 4);
    public static final Fraction TWO_QUARTERS = new Fraction(2, 4);
    public static final Fraction THREE_QUARTERS = new Fraction(3, 4);
    public static final Fraction ONE_FIFTH = new Fraction(1, 5);
    public static final Fraction TWO_FIFTHS = new Fraction(2, 5);
    public static final Fraction THREE_FIFTHS = new Fraction(3, 5);
    public static final Fraction FOUR_FIFTHS = new Fraction(4, 5);
    private final int numerator;
    private final int denominator;
    private transient int hashCode = 0;
    private transient String toString = null;
    private transient String toProperString = null;

    private Fraction(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public static Fraction getFraction(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (denominator < 0) {
            if (numerator == Integer.MIN_VALUE || denominator == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            numerator = -numerator;
            denominator = -denominator;
        }
        return new Fraction(numerator, denominator);
    }

    public static Fraction getFraction(int whole, int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (denominator < 0) {
            throw new ArithmeticException("The denominator must not be negative");
        }
        if (numerator < 0) {
            throw new ArithmeticException("The numerator must not be negative");
        }
        long l2 = whole < 0 ? (long)whole * (long)denominator - (long)numerator : (long)whole * (long)denominator + (long)numerator;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("Numerator too large to represent as an Integer.");
        }
        return new Fraction((int)l2, denominator);
    }

    public static Fraction getReducedFraction(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (numerator == 0) {
            return ZERO;
        }
        if (denominator == Integer.MIN_VALUE && (numerator & 1) == 0) {
            numerator /= 2;
            denominator /= 2;
        }
        if (denominator < 0) {
            if (numerator == Integer.MIN_VALUE || denominator == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            numerator = -numerator;
            denominator = -denominator;
        }
        int n2 = Fraction.greatestCommonDivisor(numerator, denominator);
        return new Fraction(numerator /= n2, denominator /= n2);
    }

    public static Fraction getFraction(double value) {
        int n2;
        double d2;
        int n3 = value < 0.0 ? -1 : 1;
        if ((value = Math.abs(value)) > 2.147483647E9 || Double.isNaN(value)) {
            throw new ArithmeticException("The value must not be greater than Integer.MAX_VALUE or NaN");
        }
        int n4 = (int)value;
        int n5 = 0;
        int n6 = 1;
        int n7 = 1;
        int n8 = 0;
        int n9 = (int)(value -= (double)n4);
        double d3 = 1.0;
        double d4 = value - (double)n9;
        double d5 = Double.MAX_VALUE;
        int n10 = 1;
        do {
            d2 = d5;
            int n11 = (int)(d3 / d4);
            double d6 = d4;
            double d7 = d3 - (double)n11 * d4;
            int n12 = n9 * n7 + n5;
            n2 = n9 * n8 + n6;
            double d8 = (double)n12 / (double)n2;
            d5 = Math.abs(value - d8);
            n9 = n11;
            d3 = d6;
            d4 = d7;
            n5 = n7;
            n6 = n8;
            n7 = n12;
            n8 = n2;
        } while (d2 > d5 && n2 <= 10000 && n2 > 0 && ++n10 < 25);
        if (n10 == 25) {
            throw new ArithmeticException("Unable to convert double to fraction");
        }
        return Fraction.getReducedFraction((n5 + n4 * n6) * n3, n6);
    }

    public static Fraction getFraction(String str) {
        Validate.isTrue(str != null, "The string must not be null", new Object[0]);
        int n2 = str.indexOf(46);
        if (n2 >= 0) {
            return Fraction.getFraction(Double.parseDouble(str));
        }
        n2 = str.indexOf(32);
        if (n2 > 0) {
            int n3 = Integer.parseInt(str.substring(0, n2));
            if ((n2 = (str = str.substring(n2 + 1)).indexOf(47)) < 0) {
                throw new NumberFormatException("The fraction could not be parsed as the format X Y/Z");
            }
            int n4 = Integer.parseInt(str.substring(0, n2));
            int n5 = Integer.parseInt(str.substring(n2 + 1));
            return Fraction.getFraction(n3, n4, n5);
        }
        n2 = str.indexOf(47);
        if (n2 < 0) {
            return Fraction.getFraction(Integer.parseInt(str), 1);
        }
        int n6 = Integer.parseInt(str.substring(0, n2));
        int n7 = Integer.parseInt(str.substring(n2 + 1));
        return Fraction.getFraction(n6, n7);
    }

    public final int getNumerator() {
        return this.numerator;
    }

    public final int getDenominator() {
        return this.denominator;
    }

    public final int getProperNumerator() {
        return Math.abs(this.numerator % this.denominator);
    }

    public final int getProperWhole() {
        return this.numerator / this.denominator;
    }

    @Override
    public final int intValue() {
        return this.numerator / this.denominator;
    }

    @Override
    public final long longValue() {
        return (long)this.numerator / (long)this.denominator;
    }

    @Override
    public final float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    @Override
    public final double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public final Fraction reduce() {
        if (this.numerator == 0) {
            if (this.equals(ZERO)) {
                return this;
            }
            return ZERO;
        }
        int n2 = Fraction.greatestCommonDivisor(Math.abs(this.numerator), this.denominator);
        if (n2 == 1) {
            return this;
        }
        return Fraction.getFraction(this.numerator / n2, this.denominator / n2);
    }

    public final Fraction invert() {
        if (this.numerator == 0) {
            throw new ArithmeticException("Unable to invert zero.");
        }
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: can't negate numerator");
        }
        if (this.numerator < 0) {
            return new Fraction(-this.denominator, -this.numerator);
        }
        return new Fraction(this.denominator, this.numerator);
    }

    public final Fraction negate() {
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: too large to negate");
        }
        return new Fraction(-this.numerator, this.denominator);
    }

    public final Fraction abs() {
        if (this.numerator >= 0) {
            return this;
        }
        return this.negate();
    }

    public final Fraction pow(int power) {
        Fraction fraction;
        while (true) {
            Fraction this_;
            if (power == 1) {
                return this_;
            }
            if (power == 0) {
                return ONE;
            }
            if (power < 0) {
                if (power == Integer.MIN_VALUE) {
                    power = -(power / 2);
                    this_ = this_.invert().pow(2);
                    continue;
                }
                power = -power;
                this_ = this_.invert();
                continue;
            }
            Fraction fraction2 = this_;
            fraction = fraction2.multiplyBy(fraction2);
            if (power % 2 != 0) break;
            power /= 2;
            this_ = fraction;
        }
        return fraction.pow(power / 2).multiplyBy(this_);
    }

    private static int greatestCommonDivisor(int u2, int v2) {
        int n2;
        int n3;
        if (u2 == 0 || v2 == 0) {
            if (u2 == Integer.MIN_VALUE || v2 == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: gcd is 2^31");
            }
            return Math.abs(u2) + Math.abs(v2);
        }
        if (Math.abs(u2) == 1 || Math.abs(v2) == 1) {
            return 1;
        }
        if (u2 > 0) {
            u2 = -u2;
        }
        if (v2 > 0) {
            v2 = -v2;
        }
        for (n3 = 0; (u2 & 1) == 0 && (v2 & 1) == 0 && n3 < 31; ++n3) {
            u2 /= 2;
            v2 /= 2;
        }
        if (n3 == 31) {
            throw new ArithmeticException("overflow: gcd is 2^31");
        }
        int n4 = n2 = (u2 & 1) == 1 ? v2 : -(u2 / 2);
        while (true) {
            if ((n2 & 1) == 0) {
                n4 = n2 / 2;
                continue;
            }
            if (n2 > 0) {
                u2 = -n2;
            } else {
                v2 = n2;
            }
            if ((n2 = (v2 - u2) / 2) == 0) break;
        }
        return -u2 * (1 << n3);
    }

    private static int mulAndCheck(int x2, int y2) {
        long l2 = (long)x2 * (long)y2;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mul");
        }
        return (int)l2;
    }

    private static int mulPosAndCheck(int x2, int y2) {
        long l2 = (long)x2 * (long)y2;
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mulPos");
        }
        return (int)l2;
    }

    private static int addAndCheck(int x2, int y2) {
        long l2 = (long)x2 + (long)y2;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)l2;
    }

    private static int subAndCheck(int x2, int y2) {
        long l2 = (long)x2 - (long)y2;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)l2;
    }

    public final Fraction add(Fraction fraction) {
        return this.addSub(fraction, true);
    }

    public final Fraction subtract(Fraction fraction) {
        return this.addSub(fraction, false);
    }

    private Fraction addSub(Fraction fraction, boolean isAdd) {
        int n2;
        int n3;
        Validate.isTrue(fraction != null, "The fraction must not be null", new Object[0]);
        if (this.numerator == 0) {
            if (isAdd) {
                return fraction;
            }
            return fraction.negate();
        }
        if (fraction.numerator == 0) {
            return this;
        }
        int n4 = Fraction.greatestCommonDivisor(this.denominator, fraction.denominator);
        if (n4 == 1) {
            int n5 = Fraction.mulAndCheck(this.numerator, fraction.denominator);
            int n6 = Fraction.mulAndCheck(fraction.numerator, this.denominator);
            return new Fraction(isAdd ? Fraction.addAndCheck(n5, n6) : Fraction.subAndCheck(n5, n6), Fraction.mulPosAndCheck(this.denominator, fraction.denominator));
        }
        BigInteger bigInteger = BigInteger.valueOf(this.numerator).multiply(BigInteger.valueOf(fraction.denominator / n4));
        BigInteger bigInteger2 = BigInteger.valueOf(fraction.numerator).multiply(BigInteger.valueOf(this.denominator / n4));
        BigInteger bigInteger3 = isAdd ? bigInteger.add(bigInteger2) : bigInteger.subtract(bigInteger2);
        BigInteger bigInteger4 = bigInteger3.divide(BigInteger.valueOf(n3 = (n2 = bigInteger3.mod(BigInteger.valueOf(n4)).intValue()) == 0 ? n4 : Fraction.greatestCommonDivisor(n2, n4)));
        if (bigInteger4.bitLength() > 31) {
            throw new ArithmeticException("overflow: numerator too large after multiply");
        }
        return new Fraction(bigInteger4.intValue(), Fraction.mulPosAndCheck(this.denominator / n4, fraction.denominator / n3));
    }

    public final Fraction multiplyBy(Fraction fraction) {
        Validate.isTrue(fraction != null, "The fraction must not be null", new Object[0]);
        if (this.numerator == 0 || fraction.numerator == 0) {
            return ZERO;
        }
        int n2 = Fraction.greatestCommonDivisor(this.numerator, fraction.denominator);
        int n3 = Fraction.greatestCommonDivisor(fraction.numerator, this.denominator);
        return Fraction.getReducedFraction(Fraction.mulAndCheck(this.numerator / n2, fraction.numerator / n3), Fraction.mulPosAndCheck(this.denominator / n3, fraction.denominator / n2));
    }

    public final Fraction divideBy(Fraction fraction) {
        Validate.isTrue(fraction != null, "The fraction must not be null", new Object[0]);
        if (fraction.numerator == 0) {
            throw new ArithmeticException("The fraction to divide by must not be zero");
        }
        return this.multiplyBy(fraction.invert());
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Fraction)) {
            return false;
        }
        Fraction fraction = (Fraction)obj;
        return this.getNumerator() == fraction.getNumerator() && this.getDenominator() == fraction.getDenominator();
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * (629 + this.getNumerator()) + this.getDenominator();
        }
        return this.hashCode;
    }

    @Override
    public final int compareTo(Fraction other) {
        if (this == other) {
            return 0;
        }
        if (this.numerator == other.numerator && this.denominator == other.denominator) {
            return 0;
        }
        long l2 = (long)this.numerator * (long)other.denominator;
        long l3 = (long)other.numerator * (long)this.denominator;
        if (l2 == l3) {
            return 0;
        }
        if (l2 < l3) {
            return -1;
        }
        return 1;
    }

    public final String toString() {
        if (this.toString == null) {
            this.toString = this.getNumerator() + "/" + this.getDenominator();
        }
        return this.toString;
    }

    public final String toProperString() {
        if (this.toProperString == null) {
            int n2;
            this.toProperString = this.numerator == 0 ? "0" : (this.numerator == this.denominator ? "1" : (this.numerator == -1 * this.denominator ? "-1" : ((this.numerator > 0 ? -this.numerator : this.numerator) < -this.denominator ? ((n2 = this.getProperNumerator()) == 0 ? Integer.toString(this.getProperWhole()) : this.getProperWhole() + " " + n2 + "/" + this.getDenominator()) : this.getNumerator() + "/" + this.getDenominator())));
        }
        return this.toProperString;
    }
}

