/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.reflect.Typed;

public class TypeUtils {
    public static final WildcardType WILDCARD_ALL = TypeUtils.wildcardType().withUpperBounds(new Type[]{Object.class}).build();

    public static boolean isAssignable(Type type, Type toType) {
        return TypeUtils.isAssignable(type, toType, null);
    }

    private static boolean isAssignable(Type type, Type toType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (toType == null || toType instanceof Class) {
            return TypeUtils.isAssignable(type, (Class)toType);
        }
        if (toType instanceof ParameterizedType) {
            return TypeUtils.isAssignable(type, (ParameterizedType)toType, typeVarAssigns);
        }
        if (toType instanceof GenericArrayType) {
            return TypeUtils.isAssignable(type, (GenericArrayType)toType, typeVarAssigns);
        }
        if (toType instanceof WildcardType) {
            return TypeUtils.isAssignable(type, (WildcardType)toType, typeVarAssigns);
        }
        if (toType instanceof TypeVariable) {
            return TypeUtils.isAssignable(type, (TypeVariable)toType, typeVarAssigns);
        }
        throw new IllegalStateException("found an unhandled type: " + toType);
    }

    private static boolean isAssignable(Type type, Class<?> toClass) {
        while (true) {
            if (type == null) {
                return toClass == null || !toClass.isPrimitive();
            }
            if (toClass == null) {
                return false;
            }
            if (toClass.equals(type)) {
                return true;
            }
            if (type instanceof Class) {
                return ClassUtils.isAssignable(type, toClass);
            }
            if (!(type instanceof ParameterizedType)) break;
            type = TypeUtils.getRawType((ParameterizedType)((Object)type));
        }
        if (type instanceof TypeVariable) {
            for (Type type2 : ((TypeVariable)((Object)type)).getBounds()) {
                if (!TypeUtils.isAssignable(type2, toClass)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof GenericArrayType) {
            return toClass.equals(Object.class) || toClass.isArray() && TypeUtils.isAssignable(((GenericArrayType)((Object)type)).getGenericComponentType(), toClass.getComponentType());
        }
        if (type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static boolean isAssignable(Type type, ParameterizedType toParameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type == null) {
            return true;
        }
        if (toParameterizedType == null) {
            return false;
        }
        if (toParameterizedType.equals(type)) {
            return true;
        }
        Class<?> clazz = TypeUtils.getRawType(toParameterizedType);
        Map<TypeVariable<?>, Type> map = TypeUtils.getTypeArguments(type, clazz, null);
        if (map == null) {
            return false;
        }
        if (map.isEmpty()) {
            return true;
        }
        Map<TypeVariable<?>, Type> map2 = TypeUtils.getTypeArguments(toParameterizedType, clazz, typeVarAssigns);
        for (TypeVariable<?> typeVariable : map2.keySet()) {
            Type type2 = TypeUtils.unrollVariableAssignments(typeVariable, map2);
            Type type3 = TypeUtils.unrollVariableAssignments(typeVariable, map);
            if (type2 == null && type3 instanceof Class || type3 == null || type2.equals(type3) || type2 instanceof WildcardType && TypeUtils.isAssignable(type3, type2, typeVarAssigns)) continue;
            return false;
        }
        return true;
    }

    private static Type unrollVariableAssignments(TypeVariable<?> var, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type type;
        while ((type = typeVarAssigns.get(var)) instanceof TypeVariable && !type.equals(var)) {
            var = (TypeVariable)type;
        }
        return type;
    }

    private static boolean isAssignable(Type type, GenericArrayType toGenericArrayType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type == null) {
            return true;
        }
        if (toGenericArrayType == null) {
            return false;
        }
        if (toGenericArrayType.equals(type)) {
            return true;
        }
        Type type2 = toGenericArrayType.getGenericComponentType();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isArray() && TypeUtils.isAssignable(clazz.getComponentType(), type2, typeVarAssigns);
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.isAssignable(((GenericArrayType)type).getGenericComponentType(), type2, typeVarAssigns);
        }
        if (type instanceof WildcardType) {
            for (Type type3 : TypeUtils.getImplicitUpperBounds((WildcardType)type)) {
                if (!TypeUtils.isAssignable(type3, toGenericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof TypeVariable) {
            for (Type type4 : TypeUtils.getImplicitBounds((TypeVariable)type)) {
                if (!TypeUtils.isAssignable(type4, toGenericArrayType)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static boolean isAssignable(Type type, WildcardType toWildcardType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type type2;
        int n2;
        if (type == null) {
            return true;
        }
        if (toWildcardType == null) {
            return false;
        }
        if (toWildcardType.equals(type)) {
            return true;
        }
        Type[] typeArray = TypeUtils.getImplicitUpperBounds(toWildcardType);
        Type[] typeArray2 = TypeUtils.getImplicitLowerBounds(toWildcardType);
        if (type instanceof WildcardType) {
            Type type3;
            int n3;
            int n4;
            Type[] typeArray3;
            Type type4;
            int n5;
            WildcardType wildcardType = (WildcardType)type;
            Type[] typeArray4 = TypeUtils.getImplicitUpperBounds(wildcardType);
            Type[] typeArray5 = TypeUtils.getImplicitLowerBounds(wildcardType);
            Type[] typeArray6 = typeArray;
            int n6 = typeArray.length;
            for (n5 = 0; n5 < n6; ++n5) {
                type4 = typeArray6[n5];
                type4 = TypeUtils.substituteTypeVariables(type4, typeVarAssigns);
                typeArray3 = typeArray4;
                n4 = typeArray4.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    type3 = typeArray3[n3];
                    if (TypeUtils.isAssignable(type3, type4, typeVarAssigns)) continue;
                    return false;
                }
            }
            typeArray6 = typeArray2;
            n6 = typeArray2.length;
            for (n5 = 0; n5 < n6; ++n5) {
                type4 = typeArray6[n5];
                type4 = TypeUtils.substituteTypeVariables(type4, typeVarAssigns);
                typeArray3 = typeArray5;
                n4 = typeArray5.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    type3 = typeArray3[n3];
                    if (TypeUtils.isAssignable(type4, type3, typeVarAssigns)) continue;
                    return false;
                }
            }
            return true;
        }
        Type[] typeArray7 = typeArray;
        int n7 = typeArray.length;
        for (n2 = 0; n2 < n7; ++n2) {
            type2 = typeArray7[n2];
            if (TypeUtils.isAssignable(type, TypeUtils.substituteTypeVariables(type2, typeVarAssigns), typeVarAssigns)) continue;
            return false;
        }
        typeArray7 = typeArray2;
        n7 = typeArray2.length;
        for (n2 = 0; n2 < n7; ++n2) {
            type2 = typeArray7[n2];
            if (TypeUtils.isAssignable(TypeUtils.substituteTypeVariables(type2, typeVarAssigns), type, typeVarAssigns)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Type type, TypeVariable<?> toTypeVariable, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type == null) {
            return true;
        }
        if (toTypeVariable == null) {
            return false;
        }
        if (toTypeVariable.equals(type)) {
            return true;
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray;
            Type[] typeArray2 = typeArray = TypeUtils.getImplicitBounds((TypeVariable)type);
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Type type2 = typeArray2[i2];
                if (!TypeUtils.isAssignable(type2, toTypeVariable, typeVarAssigns)) continue;
                return true;
            }
        }
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType || type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static Type substituteTypeVariables(Type type, Map<TypeVariable<?>, Type> typeVarAssigns) {
        if (type instanceof TypeVariable && typeVarAssigns != null) {
            Type type2 = typeVarAssigns.get(type);
            if (type2 == null) {
                throw new IllegalArgumentException("missing assignment type for type variable " + type);
            }
            return type2;
        }
        return type;
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType type) {
        ParameterizedType parameterizedType = type;
        return TypeUtils.getTypeArguments(parameterizedType, TypeUtils.getRawType(parameterizedType), null);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass) {
        return TypeUtils.getTypeArguments(type, toClass, null);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        block7: {
            block0: while (true) {
                if (type instanceof Class) {
                    return TypeUtils.getTypeArguments((Class)type, toClass, subtypeVarAssigns);
                }
                if (type instanceof ParameterizedType) {
                    return TypeUtils.getTypeArguments((ParameterizedType)type, toClass, subtypeVarAssigns);
                }
                if (type instanceof GenericArrayType) {
                    toClass = toClass.isArray() ? toClass.getComponentType() : toClass;
                    type = ((GenericArrayType)type).getGenericComponentType();
                    continue;
                }
                if (type instanceof WildcardType) {
                    for (Type type2 : TypeUtils.getImplicitUpperBounds((WildcardType)type)) {
                        if (!TypeUtils.isAssignable(type2, toClass)) continue;
                        type = type2;
                        continue block0;
                    }
                    return null;
                }
                if (!(type instanceof TypeVariable)) break block7;
                for (Type type2 : TypeUtils.getImplicitBounds((TypeVariable)type)) {
                    if (!TypeUtils.isAssignable(type2, toClass)) continue;
                    type = type2;
                    continue block0;
                }
                break;
            }
            return null;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        Map<TypeVariable<?>, Type> map;
        Type[] typeArray;
        Class<?> clazz = TypeUtils.getRawType(parameterizedType);
        if (!TypeUtils.isAssignable(clazz, toClass)) {
            return null;
        }
        Type type = parameterizedType.getOwnerType();
        if (type instanceof ParameterizedType) {
            typeArray = (Type[])type;
            map = TypeUtils.getTypeArguments((ParameterizedType)typeArray, TypeUtils.getRawType((ParameterizedType)typeArray), subtypeVarAssigns);
        } else {
            map = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
        }
        HashMap hashMap = map;
        typeArray = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
            Type type2 = typeArray[i2];
            hashMap.put(typeVariableArray[i2], hashMap.containsKey(type2) ? (Type)hashMap.get(type2) : type2);
        }
        if (toClass.equals(clazz)) {
            return hashMap;
        }
        return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(clazz, toClass), toClass, hashMap);
    }

    private static Map<TypeVariable<?>, Type> getTypeArguments(Class<?> cls, Class<?> toClass, Map<TypeVariable<?>, Type> subtypeVarAssigns) {
        HashMap hashMap;
        if (!TypeUtils.isAssignable(cls, toClass)) {
            return null;
        }
        if (cls.isPrimitive()) {
            if (toClass.isPrimitive()) {
                return new HashMap();
            }
            cls = ClassUtils.primitiveToWrapper(cls);
        }
        HashMap hashMap2 = hashMap = subtypeVarAssigns == null ? new HashMap() : new HashMap(subtypeVarAssigns);
        if (toClass.equals(cls)) {
            return hashMap;
        }
        return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(cls, toClass), toClass, hashMap);
    }

    public static Map<TypeVariable<?>, Type> determineTypeArguments(Class<?> cls, ParameterizedType superType) {
        Type type;
        while (true) {
            Validate.notNull(cls, "cls is null", new Object[0]);
            Validate.notNull(superType, "superType is null", new Object[0]);
            Class<?> clazz = TypeUtils.getRawType(superType);
            if (!TypeUtils.isAssignable(cls, clazz)) {
                return null;
            }
            if (cls.equals(clazz)) {
                return TypeUtils.getTypeArguments(superType, clazz, null);
            }
            type = TypeUtils.getClosestParentType(cls, clazz);
            if (!(type instanceof Class)) break;
            cls = (Class)type;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Class<?> clazz = TypeUtils.getRawType(parameterizedType);
        Map<TypeVariable<?>, Type> map = TypeUtils.determineTypeArguments(clazz, superType);
        TypeUtils.mapTypeVariablesToArguments(cls, parameterizedType, map);
        return map;
    }

    private static <T> void mapTypeVariablesToArguments(Class<T> cls, ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> typeVarAssigns) {
        Type type = parameterizedType.getOwnerType();
        if (type instanceof ParameterizedType) {
            TypeUtils.mapTypeVariablesToArguments(cls, (ParameterizedType)type, typeVarAssigns);
        }
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeVariableArray = TypeUtils.getRawType(parameterizedType).getTypeParameters();
        List<TypeVariable<Class<T>>> list = Arrays.asList(cls.getTypeParameters());
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            TypeVariable<Class<?>> typeVariable = typeVariableArray[i2];
            Type type2 = typeArray[i2];
            if (!list.contains(type2) || !typeVarAssigns.containsKey(typeVariable)) continue;
            typeVarAssigns.put((TypeVariable)type2, typeVarAssigns.get(typeVariable));
        }
    }

    private static Type getClosestParentType(Class<?> cls, Class<?> superClass) {
        if (superClass.isInterface()) {
            Type[] typeArray = cls.getGenericInterfaces();
            Type type = null;
            Type[] typeArray2 = typeArray;
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class clazz;
                Type type2 = typeArray2[i2];
                if (type2 instanceof ParameterizedType) {
                    clazz = TypeUtils.getRawType((ParameterizedType)type2);
                } else if (type2 instanceof Class) {
                    clazz = (Class)type2;
                } else {
                    throw new IllegalStateException("Unexpected generic interface type found: " + type2);
                }
                if (!TypeUtils.isAssignable((Type)clazz, superClass) || !TypeUtils.isAssignable(type, (Type)clazz)) continue;
                type = type2;
            }
            if (type != null) {
                return type;
            }
        }
        return cls.getGenericSuperclass();
    }

    public static boolean isInstance(Object value, Type type) {
        if (type == null) {
            return false;
        }
        if (value == null) {
            return !(type instanceof Class) || !((Class)type).isPrimitive();
        }
        return TypeUtils.isAssignable(value.getClass(), type, null);
    }

    public static Type[] normalizeUpperBounds(Type[] bounds) {
        Validate.notNull(bounds, "null value specified for bounds array", new Object[0]);
        if (bounds.length < 2) {
            return bounds;
        }
        HashSet<Type> hashSet = new HashSet<Type>(bounds.length);
        Type[] typeArray = bounds;
        int n2 = bounds.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type = typeArray[i2];
            boolean bl = false;
            Type[] typeArray2 = bounds;
            int n3 = bounds.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Type type2 = typeArray2[i3];
                if (type == type2 || !TypeUtils.isAssignable(type2, type, null)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            hashSet.add(type);
        }
        HashSet<Type> hashSet2 = hashSet;
        return hashSet2.toArray(new Type[hashSet2.size()]);
    }

    public static Type[] getImplicitBounds(TypeVariable<?> typeVariable) {
        Validate.notNull(typeVariable, "typeVariable is null", new Object[0]);
        Type[] typeArray = typeVariable.getBounds();
        if (typeArray.length == 0) {
            return new Type[]{Object.class};
        }
        return TypeUtils.normalizeUpperBounds(typeArray);
    }

    public static Type[] getImplicitUpperBounds(WildcardType wildcardType) {
        Validate.notNull(wildcardType, "wildcardType is null", new Object[0]);
        Type[] typeArray = wildcardType.getUpperBounds();
        if (typeArray.length == 0) {
            return new Type[]{Object.class};
        }
        return TypeUtils.normalizeUpperBounds(typeArray);
    }

    public static Type[] getImplicitLowerBounds(WildcardType wildcardType) {
        Validate.notNull(wildcardType, "wildcardType is null", new Object[0]);
        Type[] typeArray = wildcardType.getLowerBounds();
        if (typeArray.length == 0) {
            return new Type[]{null};
        }
        return typeArray;
    }

    public static boolean typesSatisfyVariables(Map<TypeVariable<?>, Type> typeVarAssigns) {
        Validate.notNull(typeVarAssigns, "typeVarAssigns is null", new Object[0]);
        for (Map.Entry<TypeVariable<?>, Type> entry : typeVarAssigns.entrySet()) {
            TypeVariable<?> typeVariable = entry.getKey();
            Type type = entry.getValue();
            for (Type type2 : TypeUtils.getImplicitBounds(typeVariable)) {
                if (TypeUtils.isAssignable(type, TypeUtils.substituteTypeVariables(type2, typeVarAssigns), typeVarAssigns)) continue;
                return false;
            }
        }
        return true;
    }

    private static Class<?> getRawType(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getRawType();
        if (!(type instanceof Class)) {
            throw new IllegalStateException("Wait... What!? Type of rawType: " + type);
        }
        return (Class)type;
    }

    public static Class<?> getRawType(Type type, Type assigningType) {
        Object object;
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return TypeUtils.getRawType((ParameterizedType)type);
            }
            if (!(type instanceof TypeVariable)) break;
            if (assigningType == null) {
                return null;
            }
            object = ((TypeVariable)type).getGenericDeclaration();
            if (!(object instanceof Class)) {
                return null;
            }
            Map<TypeVariable<?>, Type> map = TypeUtils.getTypeArguments(assigningType, (Class)object);
            if (map == null) {
                return null;
            }
            Type type2 = map.get(type);
            if (type2 == null) {
                return null;
            }
            type = type2;
        }
        if (type instanceof GenericArrayType) {
            object = TypeUtils.getRawType(((GenericArrayType)type).getGenericComponentType(), assigningType);
            return Array.newInstance(object, 0).getClass();
        }
        if (type instanceof WildcardType) {
            return null;
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    public static boolean isArrayType(Type type) {
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
    }

    public static Type getArrayComponentType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return clazz.getComponentType();
            }
            return null;
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        return null;
    }

    public static Type unrollVariables(Map<TypeVariable<?>, Type> typeArguments, Type type) {
        block7: {
            while (true) {
                if (typeArguments == null) {
                    typeArguments = Collections.emptyMap();
                }
                if (!TypeUtils.containsTypeVariables(type)) break block7;
                if (!(type instanceof TypeVariable)) break;
                type = typeArguments.get(type);
            }
            if (type instanceof ParameterizedType) {
                Map<TypeVariable<?>, Type> map;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                if (parameterizedType.getOwnerType() == null) {
                    map = typeArguments;
                } else {
                    map = new HashMap<TypeVariable<Object>, Type>(typeArguments);
                    map.putAll(TypeUtils.getTypeArguments(parameterizedType));
                }
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    Type type2 = TypeUtils.unrollVariables(map, typeArray[i2]);
                    if (type2 == null) continue;
                    typeArray[i2] = type2;
                }
                return TypeUtils.parameterizeWithOwner(parameterizedType.getOwnerType(), (Class)parameterizedType.getRawType(), typeArray);
            }
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                return TypeUtils.wildcardType().withUpperBounds(TypeUtils.unrollBounds(typeArguments, wildcardType.getUpperBounds())).withLowerBounds(TypeUtils.unrollBounds(typeArguments, wildcardType.getLowerBounds())).build();
            }
        }
        return type;
    }

    private static Type[] unrollBounds(Map<TypeVariable<?>, Type> typeArguments, Type[] bounds) {
        Type[] typeArray = bounds;
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            Type type = TypeUtils.unrollVariables(typeArguments, typeArray[i2]);
            if (type == null) {
                typeArray = ArrayUtils.remove(typeArray, i2--);
                continue;
            }
            typeArray[i2] = type;
        }
        return typeArray;
    }

    public static boolean containsTypeVariables(Type type) {
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof Class) {
            return ((Class)type).getTypeParameters().length > 0;
        }
        if (type instanceof ParameterizedType) {
            for (Type type2 : ((ParameterizedType)type).getActualTypeArguments()) {
                if (!TypeUtils.containsTypeVariables(type2)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return TypeUtils.containsTypeVariables(TypeUtils.getImplicitLowerBounds(wildcardType)[0]) || TypeUtils.containsTypeVariables(TypeUtils.getImplicitUpperBounds(wildcardType)[0]);
        }
        return false;
    }

    public static final ParameterizedType parameterize(Class<?> raw, Type ... typeArguments) {
        return TypeUtils.parameterizeWithOwner(null, raw, typeArguments);
    }

    public static final ParameterizedType parameterize(Class<?> raw, Map<TypeVariable<?>, Type> typeArgMappings) {
        Validate.notNull(raw, "raw class is null", new Object[0]);
        Validate.notNull(typeArgMappings, "typeArgMappings is null", new Object[0]);
        return TypeUtils.parameterizeWithOwner(null, raw, TypeUtils.extractTypeArgumentsFrom(typeArgMappings, raw.getTypeParameters()));
    }

    public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> raw, Type ... typeArguments) {
        Type type;
        Validate.notNull(raw, "raw class is null", new Object[0]);
        if (raw.getEnclosingClass() == null) {
            Validate.isTrue(owner == null, "no owner allowed for top-level %s", raw);
            type = null;
        } else if (owner == null) {
            type = raw.getEnclosingClass();
        } else {
            Validate.isTrue(TypeUtils.isAssignable(owner, raw.getEnclosingClass()), "%s is invalid owner type for parameterized %s", owner, raw);
            type = owner;
        }
        Validate.noNullElements(typeArguments, "null type argument at index %s", new Object[0]);
        Validate.isTrue(raw.getTypeParameters().length == typeArguments.length, "invalid number of type parameters specified: expected %d, got %d", raw.getTypeParameters().length, typeArguments.length);
        return new ParameterizedTypeImpl(raw, type, typeArguments);
    }

    public static final ParameterizedType parameterizeWithOwner(Type owner, Class<?> raw, Map<TypeVariable<?>, Type> typeArgMappings) {
        Validate.notNull(raw, "raw class is null", new Object[0]);
        Validate.notNull(typeArgMappings, "typeArgMappings is null", new Object[0]);
        return TypeUtils.parameterizeWithOwner(owner, raw, TypeUtils.extractTypeArgumentsFrom(typeArgMappings, raw.getTypeParameters()));
    }

    private static Type[] extractTypeArgumentsFrom(Map<TypeVariable<?>, Type> mappings, TypeVariable<?>[] variables) {
        Type[] typeArray = new Type[variables.length];
        int n2 = 0;
        TypeVariable<?>[] typeVariableArray = variables;
        int n3 = variables.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            TypeVariable<?> typeVariable = typeVariableArray[i2];
            Validate.isTrue(mappings.containsKey(typeVariable), "missing argument mapping for %s", TypeUtils.toString(typeVariable));
            typeArray[n2++] = mappings.get(typeVariable);
        }
        return typeArray;
    }

    public static WildcardTypeBuilder wildcardType() {
        return new WildcardTypeBuilder();
    }

    public static GenericArrayType genericArrayType(Type componentType) {
        return new GenericArrayTypeImpl(Validate.notNull(componentType, "componentType is null", new Object[0]));
    }

    public static boolean equals(Type t1, Type t2) {
        if (Objects.equals(t1, t2)) {
            return true;
        }
        if (t1 instanceof ParameterizedType) {
            return TypeUtils.equals((ParameterizedType)t1, t2);
        }
        if (t1 instanceof GenericArrayType) {
            return TypeUtils.equals((GenericArrayType)t1, t2);
        }
        if (t1 instanceof WildcardType) {
            return TypeUtils.equals((WildcardType)t1, t2);
        }
        return false;
    }

    private static boolean equals(ParameterizedType p2, Type t2) {
        if (t2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)t2;
            if (TypeUtils.equals(p2.getRawType(), parameterizedType.getRawType()) && TypeUtils.equals(p2.getOwnerType(), parameterizedType.getOwnerType())) {
                return TypeUtils.equals(p2.getActualTypeArguments(), parameterizedType.getActualTypeArguments());
            }
        }
        return false;
    }

    private static boolean equals(GenericArrayType a2, Type t2) {
        return t2 instanceof GenericArrayType && TypeUtils.equals(a2.getGenericComponentType(), ((GenericArrayType)t2).getGenericComponentType());
    }

    private static boolean equals(WildcardType w2, Type t2) {
        if (t2 instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)t2;
            return TypeUtils.equals(TypeUtils.getImplicitLowerBounds(w2), TypeUtils.getImplicitLowerBounds(wildcardType)) && TypeUtils.equals(TypeUtils.getImplicitUpperBounds(w2), TypeUtils.getImplicitUpperBounds(wildcardType));
        }
        return false;
    }

    private static boolean equals(Type[] t1, Type[] t2) {
        if (t1.length == t2.length) {
            for (int i2 = 0; i2 < t1.length; ++i2) {
                if (TypeUtils.equals(t1[i2], t2[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String toString(Type type) {
        Validate.notNull(type);
        if (type instanceof Class) {
            return TypeUtils.classToString((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.parameterizedTypeToString((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return TypeUtils.wildcardTypeToString((WildcardType)type);
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.typeVariableToString((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.genericArrayTypeToString((GenericArrayType)type);
        }
        throw new IllegalArgumentException(ObjectUtils.identityToString(type));
    }

    public static String toLongString(TypeVariable<?> var) {
        StringBuilder stringBuilder;
        block5: {
            Validate.notNull(var, "var is null", new Object[0]);
            stringBuilder = new StringBuilder();
            Object obj = var.getGenericDeclaration();
            if (obj instanceof Class) {
                Class<?> clazz = (Class<?>)obj;
                while (true) {
                    if (clazz.getEnclosingClass() == null) {
                        stringBuilder.insert(0, clazz.getName());
                        break block5;
                    }
                    stringBuilder.insert(0, clazz.getSimpleName()).insert(0, '.');
                    clazz = clazz.getEnclosingClass();
                }
            }
            if (obj instanceof Type) {
                stringBuilder.append(TypeUtils.toString((Type)obj));
            } else {
                stringBuilder.append(obj);
            }
        }
        return stringBuilder.append(':').append(TypeUtils.typeVariableToString(var)).toString();
    }

    public static <T> Typed<T> wrap(final Type type) {
        return new Typed<T>(){

            @Override
            public final Type getType() {
                return type;
            }
        };
    }

    public static <T> Typed<T> wrap(Class<T> type) {
        return TypeUtils.wrap(type);
    }

    private static String classToString(Class<?> c2) {
        if (c2.isArray()) {
            return TypeUtils.toString(c2.getComponentType()) + "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (c2.getEnclosingClass() != null) {
            stringBuilder.append(TypeUtils.classToString(c2.getEnclosingClass())).append('.').append(c2.getSimpleName());
        } else {
            stringBuilder.append(c2.getName());
        }
        if (c2.getTypeParameters().length > 0) {
            stringBuilder.append('<');
            TypeUtils.appendAllTo(stringBuilder, ", ", c2.getTypeParameters());
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    private static String typeVariableToString(TypeVariable<?> v2) {
        StringBuilder stringBuilder = new StringBuilder(v2.getName());
        Type[] typeArray = v2.getBounds();
        if (!(typeArray.length <= 0 || typeArray.length == 1 && Object.class.equals((Object)typeArray[0]))) {
            stringBuilder.append(" extends ");
            TypeUtils.appendAllTo(stringBuilder, " & ", v2.getBounds());
        }
        return stringBuilder.toString();
    }

    private static String parameterizedTypeToString(ParameterizedType p2) {
        StringBuilder stringBuilder = new StringBuilder();
        Type type = p2.getOwnerType();
        Class clazz = (Class)p2.getRawType();
        Type[] typeArray = p2.getActualTypeArguments();
        if (type == null) {
            stringBuilder.append(clazz.getName());
        } else {
            if (type instanceof Class) {
                stringBuilder.append(((Class)type).getName());
            } else {
                stringBuilder.append(type.toString());
            }
            stringBuilder.append('.').append(clazz.getSimpleName());
        }
        TypeUtils.appendAllTo(stringBuilder.append('<'), ", ", typeArray).append('>');
        return stringBuilder.toString();
    }

    private static String wildcardTypeToString(WildcardType w2) {
        StringBuilder stringBuilder = new StringBuilder("?");
        Type[] typeArray = w2.getLowerBounds();
        Type[] typeArray2 = w2.getUpperBounds();
        if (typeArray.length > 1 || typeArray.length == 1 && typeArray[0] != null) {
            TypeUtils.appendAllTo(stringBuilder.append(" super "), " & ", typeArray);
        } else if (typeArray2.length > 1 || typeArray2.length == 1 && !Object.class.equals((Object)typeArray2[0])) {
            TypeUtils.appendAllTo(stringBuilder.append(" extends "), " & ", typeArray2);
        }
        return stringBuilder.toString();
    }

    private static String genericArrayTypeToString(GenericArrayType g2) {
        return String.format("%s[]", TypeUtils.toString(g2.getGenericComponentType()));
    }

    private static StringBuilder appendAllTo(StringBuilder buf, String sep, Type ... types) {
        Validate.notEmpty(Validate.noNullElements(types));
        if (types.length > 0) {
            buf.append(TypeUtils.toString(types[0]));
            for (int i2 = 1; i2 < types.length; ++i2) {
                buf.append(sep).append(TypeUtils.toString(types[i2]));
            }
        }
        return buf;
    }

    private static final class WildcardTypeImpl
    implements WildcardType {
        private static final Type[] EMPTY_BOUNDS = new Type[0];
        private final Type[] upperBounds;
        private final Type[] lowerBounds;

        private WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            this.upperBounds = ObjectUtils.defaultIfNull(upperBounds, EMPTY_BOUNDS);
            this.lowerBounds = ObjectUtils.defaultIfNull(lowerBounds, EMPTY_BOUNDS);
        }

        @Override
        public final Type[] getUpperBounds() {
            return (Type[])this.upperBounds.clone();
        }

        @Override
        public final Type[] getLowerBounds() {
            return (Type[])this.lowerBounds.clone();
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj instanceof WildcardType && TypeUtils.equals(this, (WildcardType)obj);
        }

        public final int hashCode() {
            int n2 = 0x4900 | Arrays.hashCode(this.upperBounds);
            n2 <<= 8;
            return n2 |= Arrays.hashCode(this.lowerBounds);
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class<?> raw;
        private final Type useOwner;
        private final Type[] typeArguments;

        private ParameterizedTypeImpl(Class<?> raw, Type useOwner, Type[] typeArguments) {
            this.raw = raw;
            this.useOwner = useOwner;
            this.typeArguments = (Type[])typeArguments.clone();
        }

        @Override
        public final Type getRawType() {
            return this.raw;
        }

        @Override
        public final Type getOwnerType() {
            return this.useOwner;
        }

        @Override
        public final Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj instanceof ParameterizedType && TypeUtils.equals(this, (ParameterizedType)obj);
        }

        public final int hashCode() {
            int n2 = 0x470 | this.raw.hashCode();
            n2 <<= 4;
            n2 |= Objects.hashCode(this.useOwner);
            n2 <<= 8;
            return n2 |= Arrays.hashCode(this.typeArguments);
        }
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        private GenericArrayTypeImpl(Type componentType) {
            this.componentType = componentType;
        }

        @Override
        public final Type getGenericComponentType() {
            return this.componentType;
        }

        public final String toString() {
            return TypeUtils.toString(this);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj instanceof GenericArrayType && TypeUtils.equals(this, (GenericArrayType)obj);
        }

        public final int hashCode() {
            int n2 = 0x430 | this.componentType.hashCode();
            return n2;
        }
    }

    public static class WildcardTypeBuilder
    implements Builder<WildcardType> {
        private Type[] upperBounds;
        private Type[] lowerBounds;

        private WildcardTypeBuilder() {
        }

        public WildcardTypeBuilder withUpperBounds(Type ... bounds) {
            this.upperBounds = bounds;
            return this;
        }

        public WildcardTypeBuilder withLowerBounds(Type ... bounds) {
            this.lowerBounds = bounds;
            return this;
        }

        @Override
        public WildcardType build() {
            return new WildcardTypeImpl(this.upperBounds, this.lowerBounds);
        }
    }
}

