/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class WeakHashtable
extends Hashtable {
    private static final long serialVersionUID = -1546036869799732453L;
    private static final int MAX_CHANGES_BEFORE_PURGE = 100;
    private static final int PARTIAL_PURGE_COUNT = 10;
    private final ReferenceQueue queue = new ReferenceQueue();
    private int changeCount = 0;

    public final boolean containsKey(Object key) {
        Referenced referenced = new Referenced(key, null);
        return super.containsKey(referenced);
    }

    public final Enumeration elements() {
        this.purge();
        return super.elements();
    }

    public final Set entrySet() {
        this.purge();
        Set set = super.entrySet();
        HashSet<Entry> hashSet = new HashSet<Entry>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Referenced referenced = (Referenced)entry.getKey();
            Object object = Referenced.access$100(referenced);
            Object v2 = entry.getValue();
            if (object == null) continue;
            Entry entry2 = new Entry(object, v2, null);
            hashSet.add(entry2);
        }
        return hashSet;
    }

    public final Object get(Object key) {
        Referenced referenced = new Referenced(key, null);
        return super.get(referenced);
    }

    public final Enumeration keys() {
        this.purge();
        Enumeration enumeration = super.keys();
        return new Enumeration(this, enumeration){
            private final Enumeration val$enumer;
            private final WeakHashtable this$0;
            {
                this.this$0 = weakHashtable;
                this.val$enumer = enumeration;
            }

            public boolean hasMoreElements() {
                return this.val$enumer.hasMoreElements();
            }

            public Object nextElement() {
                Referenced referenced = (Referenced)this.val$enumer.nextElement();
                return Referenced.access$100(referenced);
            }
        };
    }

    public final Set keySet() {
        this.purge();
        Set set = super.keySet();
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Referenced referenced = (Referenced)iterator.next();
            Object object = Referenced.access$100(referenced);
            if (object == null) continue;
            hashSet.add(object);
        }
        return hashSet;
    }

    public final synchronized Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        if (value == null) {
            throw new NullPointerException("Null values are not allowed");
        }
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        Referenced referenced = new Referenced(key, this.queue, null);
        return super.put(referenced, value);
    }

    public final void putAll(Map t2) {
        if (t2 != null) {
            Set set = t2.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public final Collection values() {
        this.purge();
        return super.values();
    }

    public final synchronized Object remove(Object key) {
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        return super.remove(new Referenced(key, null));
    }

    public final boolean isEmpty() {
        this.purge();
        return super.isEmpty();
    }

    public final int size() {
        this.purge();
        return super.size();
    }

    public final String toString() {
        this.purge();
        return super.toString();
    }

    protected final void rehash() {
        this.purge();
        super.rehash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge() {
        ArrayList<Referenced> arrayList = new ArrayList<Referenced>();
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakKey weakKey;
            while ((weakKey = (WeakKey)this.queue.poll()) != null) {
                arrayList.add(WeakKey.access$400(weakKey));
            }
        }
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            super.remove(arrayList.get(i2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOne() {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakKey weakKey = (WeakKey)this.queue.poll();
            if (weakKey != null) {
                super.remove(WeakKey.access$400(weakKey));
            }
            return;
        }
    }

    private static final class WeakKey
    extends WeakReference {
        private final Referenced referenced;

        private WeakKey(Object key, ReferenceQueue queue, Referenced referenced) {
            super(key, queue);
            this.referenced = referenced;
        }

        private Referenced getReferenced() {
            return this.referenced;
        }

        static Referenced access$400(WeakKey x0) {
            return x0.getReferenced();
        }

        WeakKey(Object x0, ReferenceQueue x1, Referenced x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    private static final class Referenced {
        private final WeakReference reference;
        private final int hashCode;

        private Referenced(Object referant) {
            this.reference = new WeakReference<Object>(referant);
            this.hashCode = referant.hashCode();
        }

        private Referenced(Object key, ReferenceQueue queue) {
            this.reference = new WeakKey(key, queue, this, null);
            this.hashCode = key.hashCode();
        }

        public final int hashCode() {
            return this.hashCode;
        }

        private Object getValue() {
            return this.reference.get();
        }

        public final boolean equals(Object o2) {
            boolean bl = false;
            if (o2 instanceof Referenced) {
                Referenced referenced = (Referenced)o2;
                Object object = this.getValue();
                Object object2 = referenced.getValue();
                if (object == null) {
                    bl = object2 == null;
                    bl = bl && this.hashCode() == referenced.hashCode();
                } else {
                    bl = object.equals(object2);
                }
            }
            return bl;
        }

        Referenced(Object x0, 1 x1) {
            this(x0);
        }

        static Object access$100(Referenced x0) {
            return x0.getValue();
        }

        Referenced(Object x0, ReferenceQueue x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static final class Entry
    implements Map.Entry {
        private final Object key;
        private final Object value;

        private Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public final boolean equals(Object o2) {
            boolean bl = false;
            if (o2 != null && o2 instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o2;
                bl = (this.getKey() == null ? entry.getKey() == null : this.getKey().equals(entry.getKey())) && (this.getValue() == null ? entry.getValue() == null : this.getValue().equals(entry.getValue()));
            }
            return bl;
        }

        public final int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public final Object setValue(Object value) {
            throw new UnsupportedOperationException("Entry.setValue is not supported.");
        }

        public final Object getValue() {
            return this.value;
        }

        public final Object getKey() {
            return this.key;
        }

        Entry(Object x0, Object x1, 1 x2) {
            this(x0, x1);
        }
    }
}

