/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.text.FormatFactory;
import org.apache.commons.text.StrMatcher;

public class ExtendedMessageFormat
extends MessageFormat {
    private static final long serialVersionUID = -2362048321261811743L;
    private static final int HASH_SEED = 31;
    private static final String DUMMY_PATTERN = "";
    private static final char START_FMT = ',';
    private static final char END_FE = '}';
    private static final char START_FE = '{';
    private static final char QUOTE = '\'';
    private String toPattern;
    private final Map<String, ? extends FormatFactory> registry;

    public ExtendedMessageFormat(String pattern) {
        this(pattern, Locale.getDefault(Locale.Category.FORMAT));
    }

    public ExtendedMessageFormat(String pattern, Locale locale) {
        this(pattern, locale, null);
    }

    public ExtendedMessageFormat(String pattern, Map<String, ? extends FormatFactory> registry) {
        this(pattern, Locale.getDefault(Locale.Category.FORMAT), registry);
    }

    public ExtendedMessageFormat(String pattern, Locale locale, Map<String, ? extends FormatFactory> registry) {
        super(DUMMY_PATTERN);
        this.setLocale(locale);
        this.registry = registry;
        this.applyPattern(pattern);
    }

    @Override
    public String toPattern() {
        return this.toPattern;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void applyPattern(String pattern) {
        int n2;
        if (this.registry == null) {
            super.applyPattern(pattern);
            this.toPattern = super.toPattern();
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder(pattern.length());
        ParsePosition parsePosition = new ParsePosition(0);
        char[] cArray = pattern.toCharArray();
        int n3 = 0;
        block4: while (parsePosition.getIndex() < pattern.length()) {
            switch (cArray[parsePosition.getIndex()]) {
                case '\'': {
                    this.appendQuotedString(pattern, parsePosition, stringBuilder);
                    continue block4;
                }
                case '{': {
                    void object2;
                    String string;
                    ++n3;
                    this.seekNonWs(pattern, parsePosition);
                    int n4 = parsePosition.getIndex();
                    n2 = this.readArgumentIndex(pattern, this.next(parsePosition));
                    stringBuilder.append('{').append(n2);
                    this.seekNonWs(pattern, parsePosition);
                    Object object = null;
                    Object var11_13 = null;
                    if (cArray[parsePosition.getIndex()] == ',' && (object = this.getFormat(string = this.parseFormatDescription(pattern, this.next(parsePosition)))) == null) {
                        stringBuilder.append(',').append(string);
                    }
                    arrayList.add(object);
                    arrayList2.add((String)(object == null ? null : object2));
                    if (arrayList.size() != n3) {
                        throw new IllegalArgumentException("The validated expression is false");
                    }
                    if (arrayList2.size() != n3) {
                        throw new IllegalArgumentException("The validated expression is false");
                    }
                    if (cArray[parsePosition.getIndex()] == '}') break;
                    throw new IllegalArgumentException("Unreadable format element at position " + n4);
                }
            }
            stringBuilder.append(cArray[parsePosition.getIndex()]);
            this.next(parsePosition);
        }
        super.applyPattern(stringBuilder.toString());
        this.toPattern = this.insertFormats(super.toPattern(), arrayList2);
        if (this.containsElements(arrayList)) {
            Format[] formatArray = this.getFormats();
            n2 = 0;
            for (Format format : arrayList) {
                if (format != null) {
                    formatArray[n2] = format;
                }
                ++n2;
            }
            super.setFormats(formatArray);
        }
    }

    @Override
    public void setFormat(int formatElementIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormats(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatsByArgumentIndex(Format[] newFormats) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!Objects.equals(this.getClass(), obj.getClass())) {
            return false;
        }
        ExtendedMessageFormat extendedMessageFormat = (ExtendedMessageFormat)obj;
        if (!Objects.equals(this.toPattern, extendedMessageFormat.toPattern)) {
            return false;
        }
        return Objects.equals(this.registry, extendedMessageFormat.registry);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + Objects.hashCode(this.registry);
        n2 = n2 * 31 + Objects.hashCode(this.toPattern);
        return n2;
    }

    private Format getFormat(String desc) {
        if (this.registry != null) {
            FormatFactory formatFactory;
            String string = desc;
            String string2 = null;
            int n2 = desc.indexOf(44);
            if (n2 > 0) {
                string = desc.substring(0, n2).trim();
                string2 = desc.substring(n2 + 1).trim();
            }
            if ((formatFactory = this.registry.get(string)) != null) {
                return formatFactory.getFormat(string, string2, this.getLocale());
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int readArgumentIndex(String pattern, ParsePosition pos) {
        var3_3 = pos.getIndex();
        this.seekNonWs(pattern, pos);
        var4_4 = new StringBuilder();
        var5_5 = false;
        while (!var5_5 && pos.getIndex() < pattern.length()) {
            var6_6 = pattern.charAt(pos.getIndex());
            if (!Character.isWhitespace(var6_6)) ** GOTO lbl-1000
            this.seekNonWs(pattern, pos);
            var6_6 = pattern.charAt(pos.getIndex());
            if (var6_6 != ',' && var6_6 != '}') {
                var5_5 = true;
            } else lbl-1000:
            // 2 sources

            {
                if ((var6_6 == ',' || var6_6 == '}') && var4_4.length() > 0) {
                    try {
                        return Integer.parseInt(var4_4.toString());
                    }
                    catch (NumberFormatException v0) {}
                }
                var5_5 = Character.isDigit(var6_6) == false;
                var4_4.append(var6_6);
            }
            this.next(pos);
        }
        if (var5_5) {
            throw new IllegalArgumentException("Invalid format argument index at position " + var3_3 + ": " + pattern.substring(var3_3, pos.getIndex()));
        }
        throw new IllegalArgumentException("Unterminated format element at position " + var3_3);
    }

    private String parseFormatDescription(String pattern, ParsePosition pos) {
        int n2 = pos.getIndex();
        this.seekNonWs(pattern, pos);
        int n3 = pos.getIndex();
        int n4 = 1;
        while (pos.getIndex() < pattern.length()) {
            switch (pattern.charAt(pos.getIndex())) {
                case '{': {
                    ++n4;
                    break;
                }
                case '}': {
                    if (--n4 != 0) break;
                    return pattern.substring(n3, pos.getIndex());
                }
                case '\'': {
                    this.getQuotedString(pattern, pos);
                }
            }
            this.next(pos);
        }
        throw new IllegalArgumentException("Unterminated format element at position " + n2);
    }

    private String insertFormats(String pattern, ArrayList<String> customPatterns) {
        if (!this.containsElements(customPatterns)) {
            return pattern;
        }
        StringBuilder stringBuilder = new StringBuilder(pattern.length() << 1);
        ParsePosition parsePosition = new ParsePosition(0);
        int n2 = -1;
        int n3 = 0;
        block5: while (parsePosition.getIndex() < pattern.length()) {
            char c2 = pattern.charAt(parsePosition.getIndex());
            switch (c2) {
                case '\'': {
                    this.appendQuotedString(pattern, parsePosition, stringBuilder);
                    continue block5;
                }
                case '{': {
                    String string;
                    stringBuilder.append('{').append(this.readArgumentIndex(pattern, this.next(parsePosition)));
                    if (++n3 != 1 || (string = customPatterns.get(++n2)) == null) continue block5;
                    stringBuilder.append(',').append(string);
                    continue block5;
                }
                case '}': {
                    --n3;
                }
            }
            stringBuilder.append(c2);
            this.next(parsePosition);
        }
        return stringBuilder.toString();
    }

    private void seekNonWs(String pattern, ParsePosition pos) {
        int len;
        char[] cArray = pattern.toCharArray();
        do {
            len = StrMatcher.splitMatcher().isMatch(cArray, pos.getIndex());
            ParsePosition parsePosition = pos;
            parsePosition.setIndex(parsePosition.getIndex() + len);
        } while (len > 0 && pos.getIndex() < pattern.length());
    }

    private ParsePosition next(ParsePosition pos) {
        ParsePosition parsePosition = pos;
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        return pos;
    }

    private StringBuilder appendQuotedString(String pattern, ParsePosition pos, StringBuilder appendTo) {
        assert (pattern.toCharArray()[pos.getIndex()] == '\'') : "Quoted string must start with quote character";
        if (appendTo != null) {
            appendTo.append('\'');
        }
        this.next(pos);
        int n2 = pos.getIndex();
        char[] cArray = pattern.toCharArray();
        for (int i2 = pos.getIndex(); i2 < pattern.length(); ++i2) {
            switch (cArray[pos.getIndex()]) {
                case '\'': {
                    this.next(pos);
                    if (appendTo == null) {
                        return null;
                    }
                    return appendTo.append(cArray, n2, pos.getIndex() - n2);
                }
            }
            this.next(pos);
        }
        throw new IllegalArgumentException("Unterminated quoted string at position " + n2);
    }

    private void getQuotedString(String pattern, ParsePosition pos) {
        this.appendQuotedString(pattern, pos, null);
    }

    private boolean containsElements(Collection<?> coll) {
        if (coll == null || coll.isEmpty()) {
            return false;
        }
        for (Object obj : coll) {
            if (obj == null) continue;
            return true;
        }
        return false;
    }
}

