/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.HashSet;
import org.apache.commons.text.similarity.SimilarityScore;

public class JaccardSimilarity
implements SimilarityScore<Double> {
    @Override
    public Double apply(CharSequence left, CharSequence right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        return (double)Math.round(this.calculateJaccardSimilarity(left, right) * 100.0) / 100.0;
    }

    private Double calculateJaccardSimilarity(CharSequence left, CharSequence right) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        boolean bl = false;
        int n2 = left.length();
        int n3 = right.length();
        if (n2 == 0 || n3 == 0) {
            return 0.0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            hashSet2.add(String.valueOf(left.charAt(i2)));
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!bl) {
                    hashSet2.add(String.valueOf(right.charAt(i3)));
                }
                if (left.charAt(i2) != right.charAt(i3)) continue;
                hashSet.add(String.valueOf(left.charAt(i2)));
            }
            bl = true;
        }
        return (double)hashSet.size() / (double)hashSet2.size();
    }
}

