/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.EditDistance;

public class LevenshteinDistance
implements EditDistance<Integer> {
    private static final LevenshteinDistance DEFAULT_INSTANCE = new LevenshteinDistance();
    private final Integer threshold;

    public LevenshteinDistance() {
        this(null);
    }

    public LevenshteinDistance(Integer threshold) {
        if (threshold != null && threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = threshold;
    }

    @Override
    public Integer apply(CharSequence left, CharSequence right) {
        if (this.threshold != null) {
            return LevenshteinDistance.limitedCompare(left, right, this.threshold);
        }
        return LevenshteinDistance.unlimitedCompare(left, right);
    }

    public static LevenshteinDistance getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    private static int limitedCompare(CharSequence left, CharSequence right, int threshold) {
        Object object;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n2 = left.length();
        int n3 = right.length();
        if (n2 == 0) {
            if (n3 <= threshold) {
                return n3;
            }
            return -1;
        }
        if (n3 == 0) {
            if (n2 <= threshold) {
                return n2;
            }
            return -1;
        }
        if (n2 > n3) {
            object = left;
            left = right;
            right = object;
            n2 = n3;
            n3 = right.length();
        }
        object = new int[n2 + 1];
        Object object2 = new int[n2 + 1];
        int n4 = Math.min(n2, threshold) + 1;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5++;
            object[n6] = n6;
        }
        Arrays.fill((int[])object, n4, ((Object)object).length, Integer.MAX_VALUE);
        Arrays.fill(object2, Integer.MAX_VALUE);
        for (n5 = 1; n5 <= n3; ++n5) {
            int n7;
            char c2 = right.charAt(n5 - 1);
            object2[0] = n5;
            int n8 = Math.max(1, n5 - threshold);
            int n9 = n7 = n5 > Integer.MAX_VALUE - threshold ? n2 : Math.min(n2, n5 + threshold);
            if (n8 > n7) {
                return -1;
            }
            if (n8 > 1) {
                object2[n8 - 1] = Integer.MAX_VALUE;
            }
            for (int i2 = n8; i2 <= n7; ++i2) {
                object2[i2] = left.charAt(i2 - 1) == c2 ? (int)object[i2 - 1] : 1 + Math.min(Math.min(object2[i2 - 1], (int)object[i2]), (int)object[i2 - 1]);
            }
            Object object3 = object;
            object = object2;
            object2 = object3;
        }
        if (object[n2] <= threshold) {
            return (int)object[n2];
        }
        return -1;
    }

    private static int unlimitedCompare(CharSequence left, CharSequence right) {
        Object object;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = left.length();
        int n3 = right.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        if (n2 > n3) {
            object = left;
            left = right;
            right = object;
            n2 = n3;
            n3 = right.length();
        }
        object = new int[n2 + 1];
        int n4 = 0;
        while (n4 <= n2) {
            int n5 = n4++;
            object[n5] = n5;
        }
        for (int i2 = 1; i2 <= n3; ++i2) {
            Object object2 = object[0];
            char c2 = right.charAt(i2 - 1);
            object[0] = i2;
            for (n4 = 1; n4 <= n2; ++n4) {
                Object object3 = object[n4];
                boolean bl = left.charAt(n4 - 1) != c2;
                object[n4] = Math.min(Math.min((int)(object[n4 - 1] + true), (int)(object[n4] + true)), (int)(object2 + bl));
                object2 = object3;
            }
        }
        return (int)object[n2];
    }
}

