/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class AggregateTranslator
extends CharSequenceTranslator {
    private final List<CharSequenceTranslator> translators = new ArrayList<CharSequenceTranslator>();

    public AggregateTranslator(CharSequenceTranslator ... translators) {
        if (translators != null) {
            CharSequenceTranslator[] charSequenceTranslatorArray = translators;
            int n2 = translators.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                CharSequenceTranslator charSequenceTranslator = charSequenceTranslatorArray[i2];
                if (charSequenceTranslator == null) continue;
                this.translators.add(charSequenceTranslator);
            }
        }
    }

    @Override
    public int translate(CharSequence input, int index, Writer out) throws IOException {
        for (CharSequenceTranslator charSequenceTranslator : this.translators) {
            int n2 = charSequenceTranslator.translate(input, index, out);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }
}

