/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.capnproto.Arena;
import org.capnproto.SegmentBuilder;
import org.capnproto.SegmentReader;

public final class BuilderArena
implements Arena {
    public static final int SUGGESTED_FIRST_SEGMENT_WORDS = 1024;
    public static final AllocationStrategy SUGGESTED_ALLOCATION_STRATEGY = AllocationStrategy.GROW_HEURISTICALLY;
    public final ArrayList<SegmentBuilder> segments = new ArrayList();
    public int nextSize;
    public final AllocationStrategy allocationStrategy;

    public BuilderArena(int n2, AllocationStrategy allocationStrategy) {
        this.nextSize = n2;
        this.allocationStrategy = allocationStrategy;
        SegmentBuilder segmentBuilder = new SegmentBuilder(ByteBuffer.allocate(n2 << 3), this);
        segmentBuilder.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.segments.add(segmentBuilder);
    }

    @Override
    public final SegmentReader tryGetSegment(int n2) {
        return this.segments.get(n2);
    }

    public final SegmentBuilder getSegment(int n2) {
        return this.segments.get(n2);
    }

    @Override
    public final void checkReadLimit(int n2) {
    }

    public final AllocateResult allocate(int n2) {
        int n3 = this.segments.size();
        int n4 = this.segments.get(n3 - 1).allocate(n2);
        if (n4 != -1) {
            return new AllocateResult(this.segments.get(n3 - 1), n4);
        }
        int n5 = Math.max(n2, this.nextSize);
        SegmentBuilder segmentBuilder = new SegmentBuilder(ByteBuffer.allocate(n5 << 3), this);
        switch (this.allocationStrategy) {
            case GROW_HEURISTICALLY: {
                this.nextSize += n5;
            }
        }
        segmentBuilder.buffer.order(ByteOrder.LITTLE_ENDIAN);
        segmentBuilder.id = n3;
        this.segments.add(segmentBuilder);
        SegmentBuilder segmentBuilder2 = segmentBuilder;
        return new AllocateResult(segmentBuilder2, segmentBuilder2.allocate(n2));
    }

    public final ByteBuffer[] getSegmentsForOutput() {
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.segments.size()];
        for (int i2 = 0; i2 < this.segments.size(); ++i2) {
            SegmentBuilder segmentBuilder = this.segments.get(i2);
            segmentBuilder.buffer.rewind();
            ByteBuffer byteBuffer = segmentBuilder.buffer.slice();
            byteBuffer.limit(segmentBuilder.currentSize() << 3);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBufferArray[i2] = byteBuffer;
        }
        return byteBufferArray;
    }

    public static class AllocateResult {
        public final SegmentBuilder segment;
        public final int offset;

        public AllocateResult(SegmentBuilder segmentBuilder, int n2) {
            this.segment = segmentBuilder;
            this.offset = n2;
        }
    }

    public static enum AllocationStrategy {
        FIXED_SIZE,
        GROW_HEURISTICALLY;

    }
}

