/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfMonthDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -4677223814028011723L;
    private final BasicChronology iChronology;

    BasicDayOfMonthDateTimeField(BasicChronology basicChronology, DurationField durationField) {
        super(DateTimeFieldType.dayOfMonth(), durationField);
        this.iChronology = basicChronology;
    }

    public final int get(long l2) {
        return this.iChronology.getDayOfMonth(l2);
    }

    public final DurationField getRangeDurationField() {
        return this.iChronology.months();
    }

    public final int getMinimumValue() {
        return 1;
    }

    public final int getMaximumValue() {
        return this.iChronology.getDaysInMonthMax();
    }

    public final int getMaximumValue(long l2) {
        return this.iChronology.getDaysInMonthMax(l2);
    }

    public final int getMaximumValue(ReadablePartial readablePartial) {
        if (readablePartial.isSupported(DateTimeFieldType.monthOfYear())) {
            int n2 = readablePartial.get(DateTimeFieldType.monthOfYear());
            if (readablePartial.isSupported(DateTimeFieldType.year())) {
                int n3 = readablePartial.get(DateTimeFieldType.year());
                return this.iChronology.getDaysInYearMonth(n3, n2);
            }
            return this.iChronology.getDaysInMonthMax(n2);
        }
        return this.getMaximumValue();
    }

    public final int getMaximumValue(ReadablePartial readablePartial, int[] nArray) {
        int n2 = readablePartial.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (readablePartial.getFieldType(i2) != DateTimeFieldType.monthOfYear()) continue;
            int n3 = nArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                if (readablePartial.getFieldType(i3) != DateTimeFieldType.year()) continue;
                int n4 = nArray[i3];
                return this.iChronology.getDaysInYearMonth(n4, n3);
            }
            return this.iChronology.getDaysInMonthMax(n3);
        }
        return this.getMaximumValue();
    }

    protected final int getMaximumValueForSet(long l2, int n2) {
        return this.iChronology.getDaysInMonthMaxForSet(l2, n2);
    }

    public final boolean isLeap(long l2) {
        return this.iChronology.isLeapDay(l2);
    }

    private Object readResolve() {
        return this.iChronology.dayOfMonth();
    }
}

