/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.convert.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConverterSet {
    private final Converter[] iConverters;
    private Entry[] iSelectEntries;

    ConverterSet(Converter[] converterArray) {
        this.iConverters = converterArray;
        this.iSelectEntries = new Entry[16];
    }

    Converter select(Class<?> clazz) throws IllegalStateException {
        int n2;
        Entry entry;
        int n3;
        Entry[] entryArray = this.iSelectEntries;
        int n4 = this.iSelectEntries.length;
        int n5 = n3 = clazz == null ? 0 : clazz.hashCode() & n4 - 1;
        while ((entry = entryArray[n3]) != null) {
            if (entry.iType == clazz) {
                return entry.iConverter;
            }
            if (++n3 < n4) continue;
            n5 = 0;
        }
        Converter converter = ConverterSet.selectSlow(this, clazz);
        entry = new Entry(clazz, converter);
        Entry[] entryArray2 = (Entry[])entryArray.clone();
        entryArray = entryArray2;
        entryArray2[n3] = entry;
        for (n2 = 0; n2 < n4; ++n2) {
            if (entryArray[n2] != null) continue;
            this.iSelectEntries = entryArray;
            return converter;
        }
        n2 = n4 << 1;
        Entry[] entryArray3 = new Entry[n2];
        for (int i2 = 0; i2 < n4; ++i2) {
            entry = entryArray[i2];
            clazz = entry.iType;
            int n6 = n3 = clazz == null ? 0 : clazz.hashCode() & n2 - 1;
            while (entryArray3[n3] != null) {
                if (++n3 < n2) continue;
                n6 = 0;
            }
            entryArray3[n3] = entry;
        }
        this.iSelectEntries = entryArray3;
        return converter;
    }

    int size() {
        return this.iConverters.length;
    }

    void copyInto(Converter[] converterArray) {
        System.arraycopy(this.iConverters, 0, converterArray, 0, this.iConverters.length);
    }

    ConverterSet add(Converter converter, Converter[] converterArray) {
        Converter[] converterArray2 = this.iConverters;
        int n2 = this.iConverters.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Converter converter2 = converterArray2[i2];
            if (converter.equals(converter2)) {
                if (converterArray != null) {
                    converterArray[0] = null;
                }
                return this;
            }
            if (converter.getSupportedType() != converter2.getSupportedType()) continue;
            Converter[] converterArray3 = new Converter[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                converterArray3[i3] = i3 != i2 ? converterArray2[i3] : converter;
            }
            if (converterArray != null) {
                converterArray[0] = converter2;
            }
            return new ConverterSet(converterArray3);
        }
        Converter[] converterArray4 = new Converter[n2 + 1];
        System.arraycopy(converterArray2, 0, converterArray4, 0, n2);
        converterArray4[n2] = converter;
        if (converterArray != null) {
            converterArray[0] = null;
        }
        return new ConverterSet(converterArray4);
    }

    ConverterSet remove(Converter converter, Converter[] converterArray) {
        Converter[] converterArray2 = this.iConverters;
        int n2 = this.iConverters.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!converter.equals(converterArray2[i2])) continue;
            return this.remove(i2, converterArray);
        }
        if (converterArray != null) {
            converterArray[0] = null;
        }
        return this;
    }

    ConverterSet remove(int n2, Converter[] converterArray) {
        Converter[] converterArray2 = this.iConverters;
        int n3 = this.iConverters.length;
        if (n2 >= n3) {
            throw new IndexOutOfBoundsException();
        }
        if (converterArray != null) {
            converterArray[0] = converterArray2[n2];
        }
        Converter[] converterArray3 = new Converter[n3 - 1];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (i2 == n2) continue;
            converterArray3[n4++] = converterArray2[i2];
        }
        return new ConverterSet(converterArray3);
    }

    private static Converter selectSlow(ConverterSet converterSet, Class<?> clazz) {
        Class<?> clazz2;
        Converter converter;
        int n2;
        Converter[] converterArray = converterSet.iConverters;
        int n3 = n2 = converterSet.iConverters.length;
        while (--n3 >= 0) {
            converter = converterArray[n3];
            clazz2 = converter.getSupportedType();
            if (clazz2 == clazz) {
                return converter;
            }
            if (clazz2 != null && (clazz == null || clazz2.isAssignableFrom(clazz))) continue;
            converterSet = converterSet.remove(n3, null);
            converterArray = converterSet.iConverters;
            n2 = converterSet.iConverters.length;
        }
        if (clazz == null || n2 == 0) {
            return null;
        }
        if (n2 == 1) {
            return converterArray[0];
        }
        n3 = n2;
        while (--n3 >= 0) {
            converter = converterArray[n3];
            clazz2 = converter.getSupportedType();
            int n4 = n2;
            while (--n4 >= 0) {
                if (n4 == n3 || !converterArray[n4].getSupportedType().isAssignableFrom(clazz2)) continue;
                converterSet = converterSet.remove(n4, null);
                converterArray = converterSet.iConverters;
                n2 = converterSet.iConverters.length;
                n3 = n2 - 1;
            }
        }
        if (n2 == 1) {
            return converterArray[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unable to find best converter for type \"");
        stringBuilder.append(clazz.getName());
        stringBuilder.append("\" from remaining set: ");
        for (int i2 = 0; i2 < n2; ++i2) {
            converter = converterArray[i2];
            Class<?> clazz3 = converter.getSupportedType();
            stringBuilder.append(converter.getClass().getName());
            stringBuilder.append('[');
            stringBuilder.append(clazz3 == null ? null : clazz3.getName());
            stringBuilder.append("], ");
        }
        throw new IllegalStateException(stringBuilder.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry {
        final Class<?> iType;
        final Converter iConverter;

        Entry(Class<?> clazz, Converter converter) {
            this.iType = clazz;
            this.iConverter = converter;
        }
    }
}

