/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.RemainderDateTimeField;
import org.joda.time.field.ScaledDurationField;

public class DividedDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 8318475124230605365L;
    final int iDivisor;
    final DurationField iDurationField;
    final DurationField iRangeDurationField;
    private final int iMin;
    private final int iMax;

    public DividedDateTimeField(DateTimeField dateTimeField, DateTimeFieldType dateTimeFieldType, int n2) {
        DateTimeField dateTimeField2 = dateTimeField;
        this(dateTimeField2, dateTimeField2.getRangeDurationField(), dateTimeFieldType, n2);
    }

    public DividedDateTimeField(DateTimeField dateTimeField, DurationField durationField, DateTimeFieldType dateTimeFieldType, int n2) {
        super(dateTimeField, dateTimeFieldType);
        if (n2 < 2) {
            throw new IllegalArgumentException("The divisor must be at least 2");
        }
        DurationField durationField2 = dateTimeField.getDurationField();
        this.iDurationField = durationField2 == null ? null : new ScaledDurationField(durationField2, dateTimeFieldType.getDurationType(), n2);
        this.iRangeDurationField = durationField;
        this.iDivisor = n2;
        int n3 = dateTimeField.getMinimumValue();
        int n4 = n3 >= 0 ? n3 / n2 : (n3 + 1) / n2 - 1;
        int n5 = dateTimeField.getMaximumValue();
        int n6 = n5 >= 0 ? n5 / n2 : (n5 + 1) / n2 - 1;
        this.iMin = n4;
        this.iMax = n6;
    }

    public DividedDateTimeField(RemainderDateTimeField remainderDateTimeField, DateTimeFieldType dateTimeFieldType) {
        this(remainderDateTimeField, null, dateTimeFieldType);
    }

    public DividedDateTimeField(RemainderDateTimeField remainderDateTimeField, DurationField durationField, DateTimeFieldType dateTimeFieldType) {
        super(remainderDateTimeField.getWrappedField(), dateTimeFieldType);
        int n2 = this.iDivisor = remainderDateTimeField.iDivisor;
        this.iDurationField = remainderDateTimeField.iRangeField;
        this.iRangeDurationField = durationField;
        DateTimeField dateTimeField = this.getWrappedField();
        int n3 = dateTimeField.getMinimumValue();
        int n4 = n3 >= 0 ? n3 / n2 : (n3 + 1) / n2 - 1;
        int n5 = dateTimeField.getMaximumValue();
        int n6 = n5 >= 0 ? n5 / n2 : (n5 + 1) / n2 - 1;
        this.iMin = n4;
        this.iMax = n6;
    }

    public DurationField getRangeDurationField() {
        if (this.iRangeDurationField != null) {
            return this.iRangeDurationField;
        }
        return super.getRangeDurationField();
    }

    public int get(long l2) {
        int n2 = this.getWrappedField().get(l2);
        if (n2 >= 0) {
            return n2 / this.iDivisor;
        }
        return (n2 + 1) / this.iDivisor - 1;
    }

    public long add(long l2, int n2) {
        return this.getWrappedField().add(l2, n2 * this.iDivisor);
    }

    public long add(long l2, long l3) {
        return this.getWrappedField().add(l2, l3 * (long)this.iDivisor);
    }

    public long addWrapField(long l2, int n2) {
        return this.set(l2, FieldUtils.getWrappedValue(this.get(l2), n2, this.iMin, this.iMax));
    }

    public int getDifference(long l2, long l3) {
        return this.getWrappedField().getDifference(l2, l3) / this.iDivisor;
    }

    public long getDifferenceAsLong(long l2, long l3) {
        return this.getWrappedField().getDifferenceAsLong(l2, l3) / (long)this.iDivisor;
    }

    public long set(long l2, int n2) {
        FieldUtils.verifyValueBounds(this, n2, this.iMin, this.iMax);
        DividedDateTimeField dividedDateTimeField = this;
        int n3 = dividedDateTimeField.getRemainder(dividedDateTimeField.getWrappedField().get(l2));
        return this.getWrappedField().set(l2, n2 * this.iDivisor + n3);
    }

    public DurationField getDurationField() {
        return this.iDurationField;
    }

    public int getMinimumValue() {
        return this.iMin;
    }

    public int getMaximumValue() {
        return this.iMax;
    }

    public long roundFloor(long l2) {
        DateTimeField dateTimeField = this.getWrappedField();
        return dateTimeField.roundFloor(dateTimeField.set(l2, this.get(l2) * this.iDivisor));
    }

    public long remainder(long l2) {
        DividedDateTimeField dividedDateTimeField = this;
        return this.set(l2, dividedDateTimeField.get(dividedDateTimeField.getWrappedField().remainder(l2)));
    }

    public int getDivisor() {
        return this.iDivisor;
    }

    private int getRemainder(int n2) {
        if (n2 >= 0) {
            return n2 % this.iDivisor;
        }
        return this.iDivisor - 1 + (n2 + 1) % this.iDivisor;
    }
}

