/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;

public class FormatUtils {
    private static final double LOG_10 = Math.log(10.0);

    private FormatUtils() {
    }

    public static void appendPaddedInteger(StringBuffer stringBuffer, int n2, int n3) {
        try {
            FormatUtils.appendPaddedInteger((Appendable)stringBuffer, n2, n3);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void appendPaddedInteger(Appendable appendable, int n2, int n3) throws IOException {
        if (n2 < 0) {
            appendable.append('-');
            if (n2 != Integer.MIN_VALUE) {
                n2 = -n2;
            } else {
                while (n3 > 10) {
                    appendable.append('0');
                    --n3;
                }
                appendable.append("2147483648");
                return;
            }
        }
        if (n2 < 10) {
            while (n3 > 1) {
                appendable.append('0');
                --n3;
            }
            appendable.append((char)(n2 + 48));
            return;
        }
        if (n2 < 100) {
            while (n3 > 2) {
                appendable.append('0');
                --n3;
            }
            int n4 = (n2 + 1) * 0xCCCCCC >> 27;
            appendable.append((char)(n4 + 48));
            appendable.append((char)(n2 - (n4 << 3) - (n4 << 1) + 48));
            return;
        }
        int n5 = n2 < 1000 ? 3 : (n2 < 10000 ? 4 : (int)(Math.log(n2) / LOG_10) + 1);
        while (n3 > n5) {
            appendable.append('0');
            --n3;
        }
        appendable.append(Integer.toString(n2));
    }

    public static void appendPaddedInteger(StringBuffer stringBuffer, long l2, int n2) {
        try {
            FormatUtils.appendPaddedInteger((Appendable)stringBuffer, l2, n2);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void appendPaddedInteger(Appendable appendable, long l2, int n2) throws IOException {
        int n3 = (int)l2;
        if ((long)n3 == l2) {
            FormatUtils.appendPaddedInteger(appendable, n3, n2);
            return;
        }
        if (n2 <= 19) {
            appendable.append(Long.toString(l2));
            return;
        }
        if (l2 < 0L) {
            appendable.append('-');
            if (l2 != Long.MIN_VALUE) {
                l2 = -l2;
            } else {
                while (n2 > 19) {
                    appendable.append('0');
                    --n2;
                }
                appendable.append("9223372036854775808");
                return;
            }
        }
        int n4 = (int)(Math.log(l2) / LOG_10) + 1;
        while (n2 > n4) {
            appendable.append('0');
            --n2;
        }
        appendable.append(Long.toString(l2));
    }

    public static void writePaddedInteger(Writer writer, int n2, int n3) throws IOException {
        if (n2 < 0) {
            writer.write(45);
            if (n2 != Integer.MIN_VALUE) {
                n2 = -n2;
            } else {
                while (n3 > 10) {
                    writer.write(48);
                    --n3;
                }
                writer.write("2147483648");
                return;
            }
        }
        if (n2 < 10) {
            while (n3 > 1) {
                writer.write(48);
                --n3;
            }
            writer.write(n2 + 48);
            return;
        }
        if (n2 < 100) {
            while (n3 > 2) {
                writer.write(48);
                --n3;
            }
            int n4 = (n2 + 1) * 0xCCCCCC >> 27;
            writer.write(n4 + 48);
            writer.write(n2 - (n4 << 3) - (n4 << 1) + 48);
            return;
        }
        int n5 = n2 < 1000 ? 3 : (n2 < 10000 ? 4 : (int)(Math.log(n2) / LOG_10) + 1);
        while (n3 > n5) {
            writer.write(48);
            --n3;
        }
        writer.write(Integer.toString(n2));
    }

    public static void writePaddedInteger(Writer writer, long l2, int n2) throws IOException {
        int n3 = (int)l2;
        if ((long)n3 == l2) {
            FormatUtils.writePaddedInteger(writer, n3, n2);
            return;
        }
        if (n2 > 19) {
            if (l2 < 0L) {
                writer.write(45);
                if (l2 != Long.MIN_VALUE) {
                    l2 = -l2;
                } else {
                    while (n2 > 19) {
                        writer.write(48);
                        --n2;
                    }
                    writer.write("9223372036854775808");
                    return;
                }
            }
            int n4 = (int)(Math.log(l2) / LOG_10) + 1;
            while (n2 > n4) {
                writer.write(48);
                --n2;
            }
        }
        writer.write(Long.toString(l2));
    }

    public static void appendUnpaddedInteger(StringBuffer stringBuffer, int n2) {
        try {
            FormatUtils.appendUnpaddedInteger((Appendable)stringBuffer, n2);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void appendUnpaddedInteger(Appendable appendable, int n2) throws IOException {
        if (n2 < 0) {
            appendable.append('-');
            if (n2 != Integer.MIN_VALUE) {
                n2 = -n2;
            } else {
                appendable.append("2147483648");
                return;
            }
        }
        if (n2 < 10) {
            appendable.append((char)(n2 + 48));
            return;
        }
        if (n2 < 100) {
            int n3 = (n2 + 1) * 0xCCCCCC >> 27;
            appendable.append((char)(n3 + 48));
            appendable.append((char)(n2 - (n3 << 3) - (n3 << 1) + 48));
            return;
        }
        appendable.append(Integer.toString(n2));
    }

    public static void appendUnpaddedInteger(StringBuffer stringBuffer, long l2) {
        try {
            FormatUtils.appendUnpaddedInteger((Appendable)stringBuffer, l2);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void appendUnpaddedInteger(Appendable appendable, long l2) throws IOException {
        int n2 = (int)l2;
        if ((long)n2 == l2) {
            FormatUtils.appendUnpaddedInteger(appendable, n2);
            return;
        }
        appendable.append(Long.toString(l2));
    }

    public static void writeUnpaddedInteger(Writer writer, int n2) throws IOException {
        if (n2 < 0) {
            writer.write(45);
            if (n2 != Integer.MIN_VALUE) {
                n2 = -n2;
            } else {
                writer.write("2147483648");
                return;
            }
        }
        if (n2 < 10) {
            writer.write(n2 + 48);
            return;
        }
        if (n2 < 100) {
            int n3 = (n2 + 1) * 0xCCCCCC >> 27;
            writer.write(n3 + 48);
            writer.write(n2 - (n3 << 3) - (n3 << 1) + 48);
            return;
        }
        writer.write(Integer.toString(n2));
    }

    public static void writeUnpaddedInteger(Writer writer, long l2) throws IOException {
        int n2 = (int)l2;
        if ((long)n2 == l2) {
            FormatUtils.writeUnpaddedInteger(writer, n2);
            return;
        }
        writer.write(Long.toString(l2));
    }

    public static int calculateDigitCount(long l2) {
        if (l2 < 0L) {
            if (l2 != Long.MIN_VALUE) {
                return FormatUtils.calculateDigitCount(-l2) + 1;
            }
            return 20;
        }
        if (l2 < 10L) {
            return 1;
        }
        if (l2 < 100L) {
            return 2;
        }
        if (l2 < 1000L) {
            return 3;
        }
        if (l2 < 10000L) {
            return 4;
        }
        return (int)(Math.log(l2) / LOG_10) + 1;
    }

    static int parseTwoDigits(CharSequence charSequence, int n2) {
        int n3 = charSequence.charAt(n2) - 48;
        return (n3 << 3) + (n3 << 1) + charSequence.charAt(n2 + 1) - 48;
    }

    static String createErrorMessage(String string, int n2) {
        int n3 = n2 + 32;
        String string2 = string.length() <= n3 + 3 ? string : string.substring(0, n3).concat("...");
        if (n2 <= 0) {
            return "Invalid format: \"" + string2 + '\"';
        }
        if (n2 >= string.length()) {
            return "Invalid format: \"" + string2 + "\" is too short";
        }
        return "Invalid format: \"" + string2 + "\" is malformed at \"" + string2.substring(n2) + '\"';
    }
}

