/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class AudioSpectrogram
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> spectrogram;

    public static AudioSpectrogram create(Scope scope, Operand<Float> input, Long windowSize, Long stride, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("AudioSpectrogram", scope.makeOpName("AudioSpectrogram"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.setAttr("window_size", windowSize);
        operationBuilder.setAttr("stride", stride);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.magnitudeSquared == null) continue;
                operationBuilder.setAttr("magnitude_squared", options2.magnitudeSquared);
            }
        }
        return new AudioSpectrogram(operationBuilder.build());
    }

    public static Options magnitudeSquared(Boolean magnitudeSquared) {
        return new Options().magnitudeSquared(magnitudeSquared);
    }

    public final Output<Float> spectrogram() {
        return this.spectrogram;
    }

    @Override
    public final Output<Float> asOutput() {
        return this.spectrogram;
    }

    private AudioSpectrogram(Operation operation) {
        super(operation);
        this.spectrogram = operation.output(0);
    }

    public static class Options {
        private Boolean magnitudeSquared;

        public Options magnitudeSquared(Boolean magnitudeSquared) {
            this.magnitudeSquared = magnitudeSquared;
            return this;
        }

        private Options() {
        }
    }
}

