/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Batch
extends PrimitiveOp {
    private List<Output<?>> batchedTensors;
    private Output<Long> batchIndex;
    private Output<Long> id;

    public static Batch create(Scope scope, Iterable<Operand<?>> inTensors, Long numBatchThreads, Long maxBatchSize, Long batchTimeoutMicros, Long gradTimeoutMicros, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Batch", scope.makeOpName("Batch"));
        operationBuilder.addInputList(Operands.asOutputs(inTensors));
        operationBuilder.setAttr("num_batch_threads", numBatchThreads);
        operationBuilder.setAttr("max_batch_size", maxBatchSize);
        operationBuilder.setAttr("batch_timeout_micros", batchTimeoutMicros);
        operationBuilder.setAttr("grad_timeout_micros", gradTimeoutMicros);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.maxEnqueuedBatches != null) {
                    operationBuilder.setAttr("max_enqueued_batches", options2.maxEnqueuedBatches);
                }
                if (options2.allowedBatchSizes != null) {
                    long[] lArray = new long[options2.allowedBatchSizes.size()];
                    for (int i3 = 0; i3 < lArray.length; ++i3) {
                        lArray[i3] = (Long)options2.allowedBatchSizes.get(i3);
                    }
                    operationBuilder.setAttr("allowed_batch_sizes", lArray);
                }
                if (options2.container != null) {
                    operationBuilder.setAttr("container", options2.container);
                }
                if (options2.sharedName != null) {
                    operationBuilder.setAttr("shared_name", options2.sharedName);
                }
                if (options2.batchingQueue == null) continue;
                operationBuilder.setAttr("batching_queue", options2.batchingQueue);
            }
        }
        return new Batch(operationBuilder.build());
    }

    public static Options maxEnqueuedBatches(Long maxEnqueuedBatches) {
        return new Options().maxEnqueuedBatches(maxEnqueuedBatches);
    }

    public static Options allowedBatchSizes(List<Long> allowedBatchSizes) {
        return new Options().allowedBatchSizes(allowedBatchSizes);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options batchingQueue(String batchingQueue) {
        return new Options().batchingQueue(batchingQueue);
    }

    public final List<Output<?>> batchedTensors() {
        return this.batchedTensors;
    }

    public final Output<Long> batchIndex() {
        return this.batchIndex;
    }

    public final Output<Long> id() {
        return this.id;
    }

    private Batch(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("batched_tensors");
        this.batchedTensors = Arrays.asList(operation.outputList(0, n2));
        int n3 = n2 + 0;
        this.batchIndex = operation.output(n3++);
        this.id = operation.output(n3);
    }

    public static class Options {
        private Long maxEnqueuedBatches;
        private List<Long> allowedBatchSizes;
        private String container;
        private String sharedName;
        private String batchingQueue;

        public Options maxEnqueuedBatches(Long maxEnqueuedBatches) {
            this.maxEnqueuedBatches = maxEnqueuedBatches;
            return this;
        }

        public Options allowedBatchSizes(List<Long> allowedBatchSizes) {
            this.allowedBatchSizes = allowedBatchSizes;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options batchingQueue(String batchingQueue) {
            this.batchingQueue = batchingQueue;
            return this;
        }

        private Options() {
        }
    }
}

