/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BatchNormWithGlobalNormalizationGrad<T>
extends PrimitiveOp {
    private Output<T> dx;
    private Output<T> dm;
    private Output<T> dv;
    private Output<T> db;
    private Output<T> dg;

    public static <T> BatchNormWithGlobalNormalizationGrad<T> create(Scope scope, Operand<T> t2, Operand<T> m2, Operand<T> v2, Operand<T> gamma, Operand<T> backprop, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("BatchNormWithGlobalNormalizationGrad", scope.makeOpName("BatchNormWithGlobalNormalizationGrad"));
        operationBuilder.addInput(t2.asOutput());
        operationBuilder.addInput(m2.asOutput());
        operationBuilder.addInput(v2.asOutput());
        operationBuilder.addInput(gamma.asOutput());
        operationBuilder.addInput(backprop.asOutput());
        operationBuilder.setAttr("variance_epsilon", varianceEpsilon.floatValue());
        operationBuilder.setAttr("scale_after_normalization", scaleAfterNormalization);
        return new BatchNormWithGlobalNormalizationGrad<T>(operationBuilder.build());
    }

    public final Output<T> dx() {
        return this.dx;
    }

    public final Output<T> dm() {
        return this.dm;
    }

    public final Output<T> dv() {
        return this.dv;
    }

    public final Output<T> db() {
        return this.db;
    }

    public final Output<T> dg() {
        return this.dg;
    }

    private BatchNormWithGlobalNormalizationGrad(Operation operation) {
        super(operation);
        this.dx = operation.output(0);
        this.dm = operation.output(1);
        this.dv = operation.output(2);
        this.db = operation.output(3);
        this.dg = operation.output(4);
    }
}

