/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BoostedTreesBucketize
extends PrimitiveOp
implements Iterable<Operand<Integer>> {
    private List<Output<Integer>> buckets;

    public static BoostedTreesBucketize create(Scope scope, Iterable<Operand<Float>> floatValues, Iterable<Operand<Float>> bucketBoundaries) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("BoostedTreesBucketize", scope.makeOpName("BoostedTreesBucketize"));
        operationBuilder.addInputList(Operands.asOutputs(floatValues));
        operationBuilder.addInputList(Operands.asOutputs(bucketBoundaries));
        return new BoostedTreesBucketize(operationBuilder.build());
    }

    public final List<Output<Integer>> buckets() {
        return this.buckets;
    }

    @Override
    public final Iterator<Operand<Integer>> iterator() {
        return this.buckets.iterator();
    }

    private BoostedTreesBucketize(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("buckets");
        this.buckets = Arrays.asList(operation.outputList(0, n2));
    }
}

