/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Conv3DBackpropFilterV2<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> Conv3DBackpropFilterV2<T> create(Scope scope, Operand<T> input, Operand<Integer> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Conv3DBackpropFilterV2", scope.makeOpName("Conv3DBackpropFilterV2"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(filterSizes.asOutput());
        operationBuilder.addInput(outBackprop.asOutput());
        long[] lArray = new long[strides.size()];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = strides.get(i2);
        }
        operationBuilder.setAttr("strides", lArray);
        operationBuilder.setAttr("padding", padding);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Options options2 = optionsArray[i3];
                if (options2.dataFormat != null) {
                    operationBuilder.setAttr("data_format", options2.dataFormat);
                }
                if (options2.dilations == null) continue;
                long[] lArray2 = new long[options2.dilations.size()];
                for (int i4 = 0; i4 < lArray2.length; ++i4) {
                    lArray2[i4] = (Long)options2.dilations.get(i4);
                }
                operationBuilder.setAttr("dilations", lArray2);
            }
        }
        return new Conv3DBackpropFilterV2<T>(operationBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private Conv3DBackpropFilterV2(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private String dataFormat;
        private List<Long> dilations;

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        private Options() {
        }
    }
}

