/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CropAndResize
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> crops;

    public static <T extends Number> CropAndResize create(Scope scope, Operand<T> image, Operand<Float> boxes, Operand<Integer> boxInd, Operand<Integer> cropSize, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("CropAndResize", scope.makeOpName("CropAndResize"));
        operationBuilder.addInput(image.asOutput());
        operationBuilder.addInput(boxes.asOutput());
        operationBuilder.addInput(boxInd.asOutput());
        operationBuilder.addInput(cropSize.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.method != null) {
                    operationBuilder.setAttr("method", options2.method);
                }
                if (options2.extrapolationValue == null) continue;
                operationBuilder.setAttr("extrapolation_value", options2.extrapolationValue.floatValue());
            }
        }
        return new CropAndResize(operationBuilder.build());
    }

    public static Options method(String method) {
        return new Options().method(method);
    }

    public static Options extrapolationValue(Float extrapolationValue) {
        return new Options().extrapolationValue(extrapolationValue);
    }

    public final Output<Float> crops() {
        return this.crops;
    }

    @Override
    public final Output<Float> asOutput() {
        return this.crops;
    }

    private CropAndResize(Operation operation) {
        super(operation);
        this.crops = operation.output(0);
    }

    public static class Options {
        private String method;
        private Float extrapolationValue;

        public Options method(String method) {
            this.method = method;
            return this;
        }

        public Options extrapolationValue(Float extrapolationValue) {
            this.extrapolationValue = extrapolationValue;
            return this;
        }

        private Options() {
        }
    }
}

