/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DecodeCSV
extends PrimitiveOp
implements Iterable<Operand<Object>> {
    private List<Output<?>> output;

    public static DecodeCSV create(Scope scope, Operand<String> records, Iterable<Operand<?>> recordDefaults, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("DecodeCSV", scope.makeOpName("DecodeCSV"));
        operationBuilder.addInput(records.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(recordDefaults));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.fieldDelim != null) {
                    operationBuilder.setAttr("field_delim", options2.fieldDelim);
                }
                if (options2.useQuoteDelim != null) {
                    operationBuilder.setAttr("use_quote_delim", options2.useQuoteDelim);
                }
                if (options2.naValue != null) {
                    operationBuilder.setAttr("na_value", options2.naValue);
                }
                if (options2.selectCols == null) continue;
                long[] lArray = new long[options2.selectCols.size()];
                for (int i3 = 0; i3 < lArray.length; ++i3) {
                    lArray[i3] = (Long)options2.selectCols.get(i3);
                }
                operationBuilder.setAttr("select_cols", lArray);
            }
        }
        return new DecodeCSV(operationBuilder.build());
    }

    public static Options fieldDelim(String fieldDelim) {
        return new Options().fieldDelim(fieldDelim);
    }

    public static Options useQuoteDelim(Boolean useQuoteDelim) {
        return new Options().useQuoteDelim(useQuoteDelim);
    }

    public static Options naValue(String naValue) {
        return new Options().naValue(naValue);
    }

    public static Options selectCols(List<Long> selectCols) {
        return new Options().selectCols(selectCols);
    }

    public final List<Output<?>> output() {
        return this.output;
    }

    @Override
    public final Iterator<Operand<Object>> iterator() {
        return this.output.iterator();
    }

    private DecodeCSV(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(0, n2));
    }

    public static class Options {
        private String fieldDelim;
        private Boolean useQuoteDelim;
        private String naValue;
        private List<Long> selectCols;

        public Options fieldDelim(String fieldDelim) {
            this.fieldDelim = fieldDelim;
            return this;
        }

        public Options useQuoteDelim(Boolean useQuoteDelim) {
            this.useQuoteDelim = useQuoteDelim;
            return this;
        }

        public Options naValue(String naValue) {
            this.naValue = naValue;
            return this;
        }

        public Options selectCols(List<Long> selectCols) {
            this.selectCols = selectCols;
            return this;
        }

        private Options() {
        }
    }
}

