/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DeserializeManySparse<T>
extends PrimitiveOp {
    private Output<Long> sparseIndices;
    private Output<T> sparseValues;
    private Output<Long> sparseShape;

    public static <T> DeserializeManySparse<T> create(Scope scope, Operand<String> serializedSparse, Class<T> dtype) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("DeserializeManySparse", scope.makeOpName("DeserializeManySparse"));
        operationBuilder.addInput(serializedSparse.asOutput());
        operationBuilder.setAttr("dtype", DataType.fromClass(dtype));
        return new DeserializeManySparse<T>(operationBuilder.build());
    }

    public final Output<Long> sparseIndices() {
        return this.sparseIndices;
    }

    public final Output<T> sparseValues() {
        return this.sparseValues;
    }

    public final Output<Long> sparseShape() {
        return this.sparseShape;
    }

    private DeserializeManySparse(Operation operation) {
        super(operation);
        this.sparseIndices = operation.output(0);
        this.sparseValues = operation.output(1);
        this.sparseShape = operation.output(2);
    }
}

