/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Dilation2D<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> Dilation2D<T> create(Scope scope, Operand<T> input, Operand<T> filter, List<Long> strides, List<Long> rates, String padding) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Dilation2D", scope.makeOpName("Dilation2D"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(filter.asOutput());
        long[] lArray = new long[strides.size()];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = strides.get(i2);
        }
        operationBuilder.setAttr("strides", lArray);
        long[] lArray2 = new long[rates.size()];
        for (int i3 = 0; i3 < lArray2.length; ++i3) {
            lArray2[i3] = rates.get(i3);
        }
        operationBuilder.setAttr("rates", lArray2);
        operationBuilder.setAttr("padding", padding);
        return new Dilation2D<T>(operationBuilder.build());
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private Dilation2D(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }
}

