/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FixedUnigramCandidateSampler
extends PrimitiveOp {
    private Output<Long> sampledCandidates;
    private Output<Float> trueExpectedCount;
    private Output<Float> sampledExpectedCount;

    public static FixedUnigramCandidateSampler create(Scope scope, Operand<Long> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("FixedUnigramCandidateSampler", scope.makeOpName("FixedUnigramCandidateSampler"));
        operationBuilder.addInput(trueClasses.asOutput());
        operationBuilder.setAttr("num_true", numTrue);
        operationBuilder.setAttr("num_sampled", numSampled);
        operationBuilder.setAttr("unique", unique);
        operationBuilder.setAttr("range_max", rangeMax);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.vocabFile != null) {
                    operationBuilder.setAttr("vocab_file", options2.vocabFile);
                }
                if (options2.distortion != null) {
                    operationBuilder.setAttr("distortion", options2.distortion.floatValue());
                }
                if (options2.numReservedIds != null) {
                    operationBuilder.setAttr("num_reserved_ids", options2.numReservedIds);
                }
                if (options2.numShards != null) {
                    operationBuilder.setAttr("num_shards", options2.numShards);
                }
                if (options2.shard != null) {
                    operationBuilder.setAttr("shard", options2.shard);
                }
                if (options2.unigrams != null) {
                    float[] fArray = new float[options2.unigrams.size()];
                    for (int i3 = 0; i3 < fArray.length; ++i3) {
                        fArray[i3] = ((Float)options2.unigrams.get(i3)).floatValue();
                    }
                    operationBuilder.setAttr("unigrams", fArray);
                }
                if (options2.seed != null) {
                    operationBuilder.setAttr("seed", options2.seed);
                }
                if (options2.seed2 == null) continue;
                operationBuilder.setAttr("seed2", options2.seed2);
            }
        }
        return new FixedUnigramCandidateSampler(operationBuilder.build());
    }

    public static Options vocabFile(String vocabFile) {
        return new Options().vocabFile(vocabFile);
    }

    public static Options distortion(Float distortion) {
        return new Options().distortion(distortion);
    }

    public static Options numReservedIds(Long numReservedIds) {
        return new Options().numReservedIds(numReservedIds);
    }

    public static Options numShards(Long numShards) {
        return new Options().numShards(numShards);
    }

    public static Options shard(Long shard) {
        return new Options().shard(shard);
    }

    public static Options unigrams(List<Float> unigrams) {
        return new Options().unigrams(unigrams);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public final Output<Long> sampledCandidates() {
        return this.sampledCandidates;
    }

    public final Output<Float> trueExpectedCount() {
        return this.trueExpectedCount;
    }

    public final Output<Float> sampledExpectedCount() {
        return this.sampledExpectedCount;
    }

    private FixedUnigramCandidateSampler(Operation operation) {
        super(operation);
        this.sampledCandidates = operation.output(0);
        this.trueExpectedCount = operation.output(1);
        this.sampledExpectedCount = operation.output(2);
    }

    public static class Options {
        private String vocabFile;
        private Float distortion;
        private Long numReservedIds;
        private Long numShards;
        private Long shard;
        private List<Float> unigrams;
        private Long seed;
        private Long seed2;

        public Options vocabFile(String vocabFile) {
            this.vocabFile = vocabFile;
            return this;
        }

        public Options distortion(Float distortion) {
            this.distortion = distortion;
            return this;
        }

        public Options numReservedIds(Long numReservedIds) {
            this.numReservedIds = numReservedIds;
            return this;
        }

        public Options numShards(Long numShards) {
            this.numShards = numShards;
            return this;
        }

        public Options shard(Long shard) {
            this.shard = shard;
            return this;
        }

        public Options unigrams(List<Float> unigrams) {
            this.unigrams = unigrams;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

