/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FractionalMaxPool<T extends Number>
extends PrimitiveOp {
    private Output<T> output;
    private Output<Long> rowPoolingSequence;
    private Output<Long> colPoolingSequence;

    public static <T extends Number> FractionalMaxPool<T> create(Scope scope, Operand<T> value, List<Float> poolingRatio, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("FractionalMaxPool", scope.makeOpName("FractionalMaxPool"));
        operationBuilder.addInput(value.asOutput());
        float[] fArray = new float[poolingRatio.size()];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = poolingRatio.get(i2).floatValue();
        }
        operationBuilder.setAttr("pooling_ratio", fArray);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Options options2 = optionsArray[i3];
                if (options2.pseudoRandom != null) {
                    operationBuilder.setAttr("pseudo_random", options2.pseudoRandom);
                }
                if (options2.overlapping != null) {
                    operationBuilder.setAttr("overlapping", options2.overlapping);
                }
                if (options2.deterministic != null) {
                    operationBuilder.setAttr("deterministic", options2.deterministic);
                }
                if (options2.seed != null) {
                    operationBuilder.setAttr("seed", options2.seed);
                }
                if (options2.seed2 == null) continue;
                operationBuilder.setAttr("seed2", options2.seed2);
            }
        }
        return new FractionalMaxPool<T>(operationBuilder.build());
    }

    public static Options pseudoRandom(Boolean pseudoRandom) {
        return new Options().pseudoRandom(pseudoRandom);
    }

    public static Options overlapping(Boolean overlapping) {
        return new Options().overlapping(overlapping);
    }

    public static Options deterministic(Boolean deterministic) {
        return new Options().deterministic(deterministic);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public final Output<T> output() {
        return this.output;
    }

    public final Output<Long> rowPoolingSequence() {
        return this.rowPoolingSequence;
    }

    public final Output<Long> colPoolingSequence() {
        return this.colPoolingSequence;
    }

    private FractionalMaxPool(Operation operation) {
        super(operation);
        this.output = operation.output(0);
        this.rowPoolingSequence = operation.output(1);
        this.colPoolingSequence = operation.output(2);
    }

    public static class Options {
        private Boolean pseudoRandom;
        private Boolean overlapping;
        private Boolean deterministic;
        private Long seed;
        private Long seed2;

        public Options pseudoRandom(Boolean pseudoRandom) {
            this.pseudoRandom = pseudoRandom;
            return this;
        }

        public Options overlapping(Boolean overlapping) {
            this.overlapping = overlapping;
            return this;
        }

        public Options deterministic(Boolean deterministic) {
            this.deterministic = deterministic;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

