/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FusedPadConv2D<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> FusedPadConv2D<T> create(Scope scope, Operand<T> input, Operand<Integer> paddings, Operand<T> filter, String mode, List<Long> strides, String padding) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("FusedPadConv2D", scope.makeOpName("FusedPadConv2D"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(paddings.asOutput());
        operationBuilder.addInput(filter.asOutput());
        operationBuilder.setAttr("mode", mode);
        long[] lArray = new long[strides.size()];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = strides.get(i2);
        }
        operationBuilder.setAttr("strides", lArray);
        operationBuilder.setAttr("padding", padding);
        return new FusedPadConv2D<T>(operationBuilder.build());
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private FusedPadConv2D(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }
}

