/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FusedResizeAndPadConv2D<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> FusedResizeAndPadConv2D<T> create(Scope scope, Operand<T> input, Operand<Integer> size, Operand<Integer> paddings, Operand<T> filter, String mode, List<Long> strides, String padding, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("FusedResizeAndPadConv2D", scope.makeOpName("FusedResizeAndPadConv2D"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(size.asOutput());
        operationBuilder.addInput(paddings.asOutput());
        operationBuilder.addInput(filter.asOutput());
        operationBuilder.setAttr("mode", mode);
        long[] lArray = new long[strides.size()];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = strides.get(i2);
        }
        operationBuilder.setAttr("strides", lArray);
        operationBuilder.setAttr("padding", padding);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Options options2 = optionsArray[i3];
                if (options2.resizeAlignCorners == null) continue;
                operationBuilder.setAttr("resize_align_corners", options2.resizeAlignCorners);
            }
        }
        return new FusedResizeAndPadConv2D<T>(operationBuilder.build());
    }

    public static Options resizeAlignCorners(Boolean resizeAlignCorners) {
        return new Options().resizeAlignCorners(resizeAlignCorners);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private FusedResizeAndPadConv2D(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean resizeAlignCorners;

        public Options resizeAlignCorners(Boolean resizeAlignCorners) {
            this.resizeAlignCorners = resizeAlignCorners;
            return this;
        }

        private Options() {
        }
    }
}

