/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Gather<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T, U extends Number> Gather<T> create(Scope scope, Operand<T> params, Operand<U> indices, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Gather", scope.makeOpName("Gather"));
        operationBuilder.addInput(params.asOutput());
        operationBuilder.addInput(indices.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.validateIndices == null) continue;
                operationBuilder.setAttr("validate_indices", options2.validateIndices);
            }
        }
        return new Gather<T>(operationBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private Gather(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean validateIndices;

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }

        private Options() {
        }
    }
}

