/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class GenerateBigQueryReaderPartitions
extends PrimitiveOp
implements Operand<String> {
    private Output<String> partitions;

    public static GenerateBigQueryReaderPartitions create(Scope scope, String projectId, String datasetId, String tableId, List<String> columns, Long timestampMillis, Long numPartitions, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("GenerateBigQueryReaderPartitions", scope.makeOpName("GenerateBigQueryReaderPartitions"));
        operationBuilder.setAttr("project_id", projectId);
        operationBuilder.setAttr("dataset_id", datasetId);
        operationBuilder.setAttr("table_id", tableId);
        String[] stringArray = new String[columns.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = columns.get(i2);
        }
        operationBuilder.setAttr("columns", stringArray);
        operationBuilder.setAttr("timestamp_millis", timestampMillis);
        operationBuilder.setAttr("num_partitions", numPartitions);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Options options2 = optionsArray[i3];
                if (options2.testEndPoint == null) continue;
                operationBuilder.setAttr("test_end_point", options2.testEndPoint);
            }
        }
        return new GenerateBigQueryReaderPartitions(operationBuilder.build());
    }

    public static Options testEndPoint(String testEndPoint) {
        return new Options().testEndPoint(testEndPoint);
    }

    public final Output<String> partitions() {
        return this.partitions;
    }

    @Override
    public final Output<String> asOutput() {
        return this.partitions;
    }

    private GenerateBigQueryReaderPartitions(Operation operation) {
        super(operation);
        this.partitions = operation.output(0);
    }

    public static class Options {
        private String testEndPoint;

        public Options testEndPoint(String testEndPoint) {
            this.testEndPoint = testEndPoint;
            return this;
        }

        private Options() {
        }
    }
}

