/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MatrixSolveLs<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> MatrixSolveLs<T> create(Scope scope, Operand<T> matrix, Operand<T> rhs, Operand<Double> l2Regularizer, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("MatrixSolveLs", scope.makeOpName("MatrixSolveLs"));
        operationBuilder.addInput(matrix.asOutput());
        operationBuilder.addInput(rhs.asOutput());
        operationBuilder.addInput(l2Regularizer.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.fast == null) continue;
                operationBuilder.setAttr("fast", options2.fast);
            }
        }
        return new MatrixSolveLs<T>(operationBuilder.build());
    }

    public static Options fast(Boolean fast) {
        return new Options().fast(fast);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private MatrixSolveLs(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean fast;

        public Options fast(Boolean fast) {
            this.fast = fast;
            return this;
        }

        private Options() {
        }
    }
}

