/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MatrixTriangularSolve<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> MatrixTriangularSolve<T> create(Scope scope, Operand<T> matrix, Operand<T> rhs, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("MatrixTriangularSolve", scope.makeOpName("MatrixTriangularSolve"));
        operationBuilder.addInput(matrix.asOutput());
        operationBuilder.addInput(rhs.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.lower != null) {
                    operationBuilder.setAttr("lower", options2.lower);
                }
                if (options2.adjoint == null) continue;
                operationBuilder.setAttr("adjoint", options2.adjoint);
            }
        }
        return new MatrixTriangularSolve<T>(operationBuilder.build());
    }

    public static Options lower(Boolean lower) {
        return new Options().lower(lower);
    }

    public static Options adjoint(Boolean adjoint) {
        return new Options().adjoint(adjoint);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private MatrixTriangularSolve(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean lower;
        private Boolean adjoint;

        public Options lower(Boolean lower) {
            this.lower = lower;
            return this;
        }

        public Options adjoint(Boolean adjoint) {
            this.adjoint = adjoint;
            return this;
        }

        private Options() {
        }
    }
}

