/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class OrderedMapStage
extends PrimitiveOp {
    public static OrderedMapStage create(Scope scope, Operand<Long> key, Operand<Integer> indices, Iterable<Operand<?>> values, List<Class<?>> dtypes, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("OrderedMapStage", scope.makeOpName("OrderedMapStage"));
        operationBuilder.addInput(key.asOutput());
        operationBuilder.addInput(indices.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(values));
        DataType[] dataTypeArray = new DataType[dtypes.size()];
        for (int i2 = 0; i2 < dataTypeArray.length; ++i2) {
            dataTypeArray[i2] = DataType.fromClass(dtypes.get(i2));
        }
        operationBuilder.setAttr("dtypes", dataTypeArray);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Options options2 = optionsArray[i3];
                if (options2.capacity != null) {
                    operationBuilder.setAttr("capacity", options2.capacity);
                }
                if (options2.memoryLimit != null) {
                    operationBuilder.setAttr("memory_limit", options2.memoryLimit);
                }
                if (options2.container != null) {
                    operationBuilder.setAttr("container", options2.container);
                }
                if (options2.sharedName == null) continue;
                operationBuilder.setAttr("shared_name", options2.sharedName);
            }
        }
        return new OrderedMapStage(operationBuilder.build());
    }

    public static Options capacity(Long capacity) {
        return new Options().capacity(capacity);
    }

    public static Options memoryLimit(Long memoryLimit) {
        return new Options().memoryLimit(memoryLimit);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    private OrderedMapStage(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Long capacity;
        private Long memoryLimit;
        private String container;
        private String sharedName;

        public Options capacity(Long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Options memoryLimit(Long memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

