/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ParseSequenceExample
extends PrimitiveOp {
    private List<Output<Long>> contextSparseIndices;
    private List<Output<?>> contextSparseValues;
    private List<Output<Long>> contextSparseShapes;
    private List<Output<?>> contextDenseValues;
    private List<Output<Long>> featureListSparseIndices;
    private List<Output<?>> featureListSparseValues;
    private List<Output<Long>> featureListSparseShapes;
    private List<Output<?>> featureListDenseValues;
    private List<Output<Long>> featureListDenseLengths;

    public static ParseSequenceExample create(Scope scope, Operand<String> serialized, Operand<String> debugName, Iterable<Operand<?>> contextDenseDefaults, List<String> featureListDenseMissingAssumedEmpty, List<String> contextSparseKeys, List<String> contextDenseKeys, List<String> featureListSparseKeys, List<String> featureListDenseKeys, List<Class<?>> contextSparseTypes, List<Class<?>> featureListDenseTypes, List<Class<?>> featureListSparseTypes, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ParseSequenceExample", scope.makeOpName("ParseSequenceExample"));
        operationBuilder.addInput(serialized.asOutput());
        operationBuilder.addInput(debugName.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(contextDenseDefaults));
        String[] stringArray = new String[featureListDenseMissingAssumedEmpty.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = featureListDenseMissingAssumedEmpty.get(i2);
        }
        operationBuilder.setAttr("feature_list_dense_missing_assumed_empty", stringArray);
        String[] stringArray2 = new String[contextSparseKeys.size()];
        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
            stringArray2[i3] = contextSparseKeys.get(i3);
        }
        operationBuilder.setAttr("context_sparse_keys", stringArray2);
        String[] stringArray3 = new String[contextDenseKeys.size()];
        for (int i4 = 0; i4 < stringArray3.length; ++i4) {
            stringArray3[i4] = contextDenseKeys.get(i4);
        }
        operationBuilder.setAttr("context_dense_keys", stringArray3);
        String[] stringArray4 = new String[featureListSparseKeys.size()];
        for (int i5 = 0; i5 < stringArray4.length; ++i5) {
            stringArray4[i5] = featureListSparseKeys.get(i5);
        }
        operationBuilder.setAttr("feature_list_sparse_keys", stringArray4);
        String[] stringArray5 = new String[featureListDenseKeys.size()];
        for (int i6 = 0; i6 < stringArray5.length; ++i6) {
            stringArray5[i6] = featureListDenseKeys.get(i6);
        }
        operationBuilder.setAttr("feature_list_dense_keys", stringArray5);
        DataType[] dataTypeArray = new DataType[contextSparseTypes.size()];
        for (int i7 = 0; i7 < dataTypeArray.length; ++i7) {
            dataTypeArray[i7] = DataType.fromClass(contextSparseTypes.get(i7));
        }
        operationBuilder.setAttr("context_sparse_types", dataTypeArray);
        DataType[] dataTypeArray2 = new DataType[featureListDenseTypes.size()];
        for (int i8 = 0; i8 < dataTypeArray2.length; ++i8) {
            dataTypeArray2[i8] = DataType.fromClass(featureListDenseTypes.get(i8));
        }
        operationBuilder.setAttr("feature_list_dense_types", dataTypeArray2);
        DataType[] dataTypeArray3 = new DataType[featureListSparseTypes.size()];
        for (int i9 = 0; i9 < dataTypeArray3.length; ++i9) {
            dataTypeArray3[i9] = DataType.fromClass(featureListSparseTypes.get(i9));
        }
        operationBuilder.setAttr("feature_list_sparse_types", dataTypeArray3);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i10 = 0; i10 < n2; ++i10) {
                int n3;
                Shape[] shapeArray;
                Options options2 = optionsArray[i10];
                if (options2.NcontextSparse != null) {
                    operationBuilder.setAttr("Ncontext_sparse", options2.NcontextSparse);
                }
                if (options2.NcontextDense != null) {
                    operationBuilder.setAttr("Ncontext_dense", options2.NcontextDense);
                }
                if (options2.NfeatureListSparse != null) {
                    operationBuilder.setAttr("Nfeature_list_sparse", options2.NfeatureListSparse);
                }
                if (options2.NfeatureListDense != null) {
                    operationBuilder.setAttr("Nfeature_list_dense", options2.NfeatureListDense);
                }
                if (options2.contextDenseShapes != null) {
                    shapeArray = new Shape[options2.contextDenseShapes.size()];
                    for (n3 = 0; n3 < shapeArray.length; ++n3) {
                        shapeArray[n3] = (Shape)options2.contextDenseShapes.get(n3);
                    }
                    operationBuilder.setAttr("context_dense_shapes", shapeArray);
                }
                if (options2.featureListDenseShapes == null) continue;
                shapeArray = new Shape[options2.featureListDenseShapes.size()];
                for (n3 = 0; n3 < shapeArray.length; ++n3) {
                    shapeArray[n3] = (Shape)options2.featureListDenseShapes.get(n3);
                }
                operationBuilder.setAttr("feature_list_dense_shapes", shapeArray);
            }
        }
        return new ParseSequenceExample(operationBuilder.build());
    }

    public static Options NcontextSparse(Long NcontextSparse) {
        return new Options().NcontextSparse(NcontextSparse);
    }

    public static Options NcontextDense(Long NcontextDense) {
        return new Options().NcontextDense(NcontextDense);
    }

    public static Options NfeatureListSparse(Long NfeatureListSparse) {
        return new Options().NfeatureListSparse(NfeatureListSparse);
    }

    public static Options NfeatureListDense(Long NfeatureListDense) {
        return new Options().NfeatureListDense(NfeatureListDense);
    }

    public static Options contextDenseShapes(List<Shape> contextDenseShapes) {
        return new Options().contextDenseShapes(contextDenseShapes);
    }

    public static Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
        return new Options().featureListDenseShapes(featureListDenseShapes);
    }

    public final List<Output<Long>> contextSparseIndices() {
        return this.contextSparseIndices;
    }

    public final List<Output<?>> contextSparseValues() {
        return this.contextSparseValues;
    }

    public final List<Output<Long>> contextSparseShapes() {
        return this.contextSparseShapes;
    }

    public final List<Output<?>> contextDenseValues() {
        return this.contextDenseValues;
    }

    public final List<Output<Long>> featureListSparseIndices() {
        return this.featureListSparseIndices;
    }

    public final List<Output<?>> featureListSparseValues() {
        return this.featureListSparseValues;
    }

    public final List<Output<Long>> featureListSparseShapes() {
        return this.featureListSparseShapes;
    }

    public final List<Output<?>> featureListDenseValues() {
        return this.featureListDenseValues;
    }

    public final List<Output<Long>> featureListDenseLengths() {
        return this.featureListDenseLengths;
    }

    private ParseSequenceExample(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("context_sparse_indices");
        this.contextSparseIndices = Arrays.asList(operation.outputList(0, n2));
        int n3 = n2 + 0;
        int n4 = operation.outputListLength("context_sparse_values");
        this.contextSparseValues = Arrays.asList(operation.outputList(n3, n4));
        int n5 = operation.outputListLength("context_sparse_shapes");
        this.contextSparseShapes = Arrays.asList(operation.outputList(n3 += n4, n5));
        int n6 = operation.outputListLength("context_dense_values");
        this.contextDenseValues = Arrays.asList(operation.outputList(n3 += n5, n6));
        int n7 = operation.outputListLength("feature_list_sparse_indices");
        this.featureListSparseIndices = Arrays.asList(operation.outputList(n3 += n6, n7));
        int n8 = operation.outputListLength("feature_list_sparse_values");
        this.featureListSparseValues = Arrays.asList(operation.outputList(n3 += n7, n8));
        int n9 = operation.outputListLength("feature_list_sparse_shapes");
        this.featureListSparseShapes = Arrays.asList(operation.outputList(n3 += n8, n9));
        int n10 = operation.outputListLength("feature_list_dense_values");
        this.featureListDenseValues = Arrays.asList(operation.outputList(n3 += n9, n10));
        int n11 = operation.outputListLength("feature_list_dense_lengths");
        this.featureListDenseLengths = Arrays.asList(operation.outputList(n3 += n10, n11));
    }

    public static class Options {
        private Long NcontextSparse;
        private Long NcontextDense;
        private Long NfeatureListSparse;
        private Long NfeatureListDense;
        private List<Shape> contextDenseShapes;
        private List<Shape> featureListDenseShapes;

        public Options NcontextSparse(Long NcontextSparse) {
            this.NcontextSparse = NcontextSparse;
            return this;
        }

        public Options NcontextDense(Long NcontextDense) {
            this.NcontextDense = NcontextDense;
            return this;
        }

        public Options NfeatureListSparse(Long NfeatureListSparse) {
            this.NfeatureListSparse = NfeatureListSparse;
            return this;
        }

        public Options NfeatureListDense(Long NfeatureListDense) {
            this.NfeatureListDense = NfeatureListDense;
            return this;
        }

        public Options contextDenseShapes(List<Shape> contextDenseShapes) {
            this.contextDenseShapes = contextDenseShapes;
            return this;
        }

        public Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
            this.featureListDenseShapes = featureListDenseShapes;
            return this;
        }

        private Options() {
        }
    }
}

