/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ParseSingleExample
extends PrimitiveOp {
    private List<Output<Long>> sparseIndices;
    private List<Output<?>> sparseValues;
    private List<Output<Long>> sparseShapes;
    private List<Output<?>> denseValues;

    public static ParseSingleExample create(Scope scope, Operand<String> serialized, Iterable<Operand<?>> denseDefaults, Long numSparse, List<String> sparseKeys, List<String> denseKeys, List<Class<?>> sparseTypes, List<Shape> denseShapes) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ParseSingleExample", scope.makeOpName("ParseSingleExample"));
        operationBuilder.addInput(serialized.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(denseDefaults));
        operationBuilder.setAttr("num_sparse", numSparse);
        String[] stringArray = new String[sparseKeys.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = sparseKeys.get(i2);
        }
        operationBuilder.setAttr("sparse_keys", stringArray);
        String[] stringArray2 = new String[denseKeys.size()];
        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
            stringArray2[i3] = denseKeys.get(i3);
        }
        operationBuilder.setAttr("dense_keys", stringArray2);
        DataType[] dataTypeArray = new DataType[sparseTypes.size()];
        for (int i4 = 0; i4 < dataTypeArray.length; ++i4) {
            dataTypeArray[i4] = DataType.fromClass(sparseTypes.get(i4));
        }
        operationBuilder.setAttr("sparse_types", dataTypeArray);
        Shape[] shapeArray = new Shape[denseShapes.size()];
        for (int i5 = 0; i5 < shapeArray.length; ++i5) {
            shapeArray[i5] = denseShapes.get(i5);
        }
        operationBuilder.setAttr("dense_shapes", shapeArray);
        return new ParseSingleExample(operationBuilder.build());
    }

    public final List<Output<Long>> sparseIndices() {
        return this.sparseIndices;
    }

    public final List<Output<?>> sparseValues() {
        return this.sparseValues;
    }

    public final List<Output<Long>> sparseShapes() {
        return this.sparseShapes;
    }

    public final List<Output<?>> denseValues() {
        return this.denseValues;
    }

    private ParseSingleExample(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("sparse_indices");
        this.sparseIndices = Arrays.asList(operation.outputList(0, n2));
        int n3 = n2 + 0;
        int n4 = operation.outputListLength("sparse_values");
        this.sparseValues = Arrays.asList(operation.outputList(n3, n4));
        int n5 = operation.outputListLength("sparse_shapes");
        this.sparseShapes = Arrays.asList(operation.outputList(n3 += n4, n5));
        int n6 = operation.outputListLength("dense_values");
        this.denseValues = Arrays.asList(operation.outputList(n3 += n5, n6));
    }
}

