/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedInstanceNorm<T>
extends PrimitiveOp {
    private Output<T> y;
    private Output<Float> yMin;
    private Output<Float> yMax;

    public static <T> QuantizedInstanceNorm<T> create(Scope scope, Operand<T> x2, Operand<Float> xMin, Operand<Float> xMax, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizedInstanceNorm", scope.makeOpName("QuantizedInstanceNorm"));
        operationBuilder.addInput(x2.asOutput());
        operationBuilder.addInput(xMin.asOutput());
        operationBuilder.addInput(xMax.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.outputRangeGiven != null) {
                    operationBuilder.setAttr("output_range_given", options2.outputRangeGiven);
                }
                if (options2.givenYMin != null) {
                    operationBuilder.setAttr("given_y_min", options2.givenYMin.floatValue());
                }
                if (options2.givenYMax != null) {
                    operationBuilder.setAttr("given_y_max", options2.givenYMax.floatValue());
                }
                if (options2.varianceEpsilon != null) {
                    operationBuilder.setAttr("variance_epsilon", options2.varianceEpsilon.floatValue());
                }
                if (options2.minSeparation == null) continue;
                operationBuilder.setAttr("min_separation", options2.minSeparation.floatValue());
            }
        }
        return new QuantizedInstanceNorm<T>(operationBuilder.build());
    }

    public static Options outputRangeGiven(Boolean outputRangeGiven) {
        return new Options().outputRangeGiven(outputRangeGiven);
    }

    public static Options givenYMin(Float givenYMin) {
        return new Options().givenYMin(givenYMin);
    }

    public static Options givenYMax(Float givenYMax) {
        return new Options().givenYMax(givenYMax);
    }

    public static Options varianceEpsilon(Float varianceEpsilon) {
        return new Options().varianceEpsilon(varianceEpsilon);
    }

    public static Options minSeparation(Float minSeparation) {
        return new Options().minSeparation(minSeparation);
    }

    public final Output<T> y() {
        return this.y;
    }

    public final Output<Float> yMin() {
        return this.yMin;
    }

    public final Output<Float> yMax() {
        return this.yMax;
    }

    private QuantizedInstanceNorm(Operation operation) {
        super(operation);
        this.y = operation.output(0);
        this.yMin = operation.output(1);
        this.yMax = operation.output(2);
    }

    public static class Options {
        private Boolean outputRangeGiven;
        private Float givenYMin;
        private Float givenYMax;
        private Float varianceEpsilon;
        private Float minSeparation;

        public Options outputRangeGiven(Boolean outputRangeGiven) {
            this.outputRangeGiven = outputRangeGiven;
            return this;
        }

        public Options givenYMin(Float givenYMin) {
            this.givenYMin = givenYMin;
            return this;
        }

        public Options givenYMax(Float givenYMax) {
            this.givenYMax = givenYMax;
            return this;
        }

        public Options varianceEpsilon(Float varianceEpsilon) {
            this.varianceEpsilon = varianceEpsilon;
            return this;
        }

        public Options minSeparation(Float minSeparation) {
            this.minSeparation = minSeparation;
            return this;
        }

        private Options() {
        }
    }
}

