/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedMatMul<V>
extends PrimitiveOp {
    private Output<V> out;
    private Output<Float> minOut;
    private Output<Float> maxOut;

    public static <V, T, U, W> QuantizedMatMul<V> create(Scope scope, Operand<T> a2, Operand<U> b2, Operand<Float> minA, Operand<Float> maxA, Operand<Float> minB, Operand<Float> maxB, Class<V> Toutput, Class<W> Tactivation, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizedMatMul", scope.makeOpName("QuantizedMatMul"));
        operationBuilder.addInput(a2.asOutput());
        operationBuilder.addInput(b2.asOutput());
        operationBuilder.addInput(minA.asOutput());
        operationBuilder.addInput(maxA.asOutput());
        operationBuilder.addInput(minB.asOutput());
        operationBuilder.addInput(maxB.asOutput());
        operationBuilder.setAttr("Toutput", DataType.fromClass(Toutput));
        operationBuilder.setAttr("Tactivation", DataType.fromClass(Tactivation));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.transposeA != null) {
                    operationBuilder.setAttr("transpose_a", options2.transposeA);
                }
                if (options2.transposeB == null) continue;
                operationBuilder.setAttr("transpose_b", options2.transposeB);
            }
        }
        return new QuantizedMatMul<V>(operationBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public final Output<V> out() {
        return this.out;
    }

    public final Output<Float> minOut() {
        return this.minOut;
    }

    public final Output<Float> maxOut() {
        return this.maxOut;
    }

    private QuantizedMatMul(Operation operation) {
        super(operation);
        this.out = operation.output(0);
        this.minOut = operation.output(1);
        this.maxOut = operation.output(2);
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        private Options() {
        }
    }
}

