/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedRelu<U>
extends PrimitiveOp {
    private Output<U> activations;
    private Output<Float> minActivations;
    private Output<Float> maxActivations;

    public static <U, T> QuantizedRelu<U> create(Scope scope, Operand<T> features, Operand<Float> minFeatures, Operand<Float> maxFeatures, Class<U> outType) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizedRelu", scope.makeOpName("QuantizedRelu"));
        operationBuilder.addInput(features.asOutput());
        operationBuilder.addInput(minFeatures.asOutput());
        operationBuilder.addInput(maxFeatures.asOutput());
        operationBuilder.setAttr("out_type", DataType.fromClass(outType));
        return new QuantizedRelu<U>(operationBuilder.build());
    }

    public final Output<U> activations() {
        return this.activations;
    }

    public final Output<Float> minActivations() {
        return this.minActivations;
    }

    public final Output<Float> maxActivations() {
        return this.maxActivations;
    }

    private QuantizedRelu(Operation operation) {
        super(operation);
        this.activations = operation.output(0);
        this.minActivations = operation.output(1);
        this.maxActivations = operation.output(2);
    }
}

