/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ResourceStridedSliceAssign
extends PrimitiveOp {
    public static <T extends Number, U> ResourceStridedSliceAssign create(Scope scope, Operand<?> ref, Operand<T> begin, Operand<T> end, Operand<T> strides, Operand<U> value, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ResourceStridedSliceAssign", scope.makeOpName("ResourceStridedSliceAssign"));
        operationBuilder.addInput(ref.asOutput());
        operationBuilder.addInput(begin.asOutput());
        operationBuilder.addInput(end.asOutput());
        operationBuilder.addInput(strides.asOutput());
        operationBuilder.addInput(value.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.beginMask != null) {
                    operationBuilder.setAttr("begin_mask", options2.beginMask);
                }
                if (options2.endMask != null) {
                    operationBuilder.setAttr("end_mask", options2.endMask);
                }
                if (options2.ellipsisMask != null) {
                    operationBuilder.setAttr("ellipsis_mask", options2.ellipsisMask);
                }
                if (options2.newAxisMask != null) {
                    operationBuilder.setAttr("new_axis_mask", options2.newAxisMask);
                }
                if (options2.shrinkAxisMask == null) continue;
                operationBuilder.setAttr("shrink_axis_mask", options2.shrinkAxisMask);
            }
        }
        return new ResourceStridedSliceAssign(operationBuilder.build());
    }

    public static Options beginMask(Long beginMask) {
        return new Options().beginMask(beginMask);
    }

    public static Options endMask(Long endMask) {
        return new Options().endMask(endMask);
    }

    public static Options ellipsisMask(Long ellipsisMask) {
        return new Options().ellipsisMask(ellipsisMask);
    }

    public static Options newAxisMask(Long newAxisMask) {
        return new Options().newAxisMask(newAxisMask);
    }

    public static Options shrinkAxisMask(Long shrinkAxisMask) {
        return new Options().shrinkAxisMask(shrinkAxisMask);
    }

    private ResourceStridedSliceAssign(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Long beginMask;
        private Long endMask;
        private Long ellipsisMask;
        private Long newAxisMask;
        private Long shrinkAxisMask;

        public Options beginMask(Long beginMask) {
            this.beginMask = beginMask;
            return this;
        }

        public Options endMask(Long endMask) {
            this.endMask = endMask;
            return this;
        }

        public Options ellipsisMask(Long ellipsisMask) {
            this.ellipsisMask = ellipsisMask;
            return this;
        }

        public Options newAxisMask(Long newAxisMask) {
            this.newAxisMask = newAxisMask;
            return this;
        }

        public Options shrinkAxisMask(Long shrinkAxisMask) {
            this.shrinkAxisMask = shrinkAxisMask;
            return this;
        }

        private Options() {
        }
    }
}

