/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ReverseSequence<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T, U extends Number> ReverseSequence<T> create(Scope scope, Operand<T> input, Operand<U> seqLengths, Long seqDim, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ReverseSequence", scope.makeOpName("ReverseSequence"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(seqLengths.asOutput());
        operationBuilder.setAttr("seq_dim", seqDim);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.batchDim == null) continue;
                operationBuilder.setAttr("batch_dim", options2.batchDim);
            }
        }
        return new ReverseSequence<T>(operationBuilder.build());
    }

    public static Options batchDim(Long batchDim) {
        return new Options().batchDim(batchDim);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private ReverseSequence(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Long batchDim;

        public Options batchDim(Long batchDim) {
            this.batchDim = batchDim;
            return this;
        }

        private Options() {
        }
    }
}

