/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Rpc
extends PrimitiveOp
implements Operand<String> {
    private Output<String> response;

    public static Rpc create(Scope scope, Operand<String> address, Operand<String> method, Operand<String> request, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Rpc", scope.makeOpName("Rpc"));
        operationBuilder.addInput(address.asOutput());
        operationBuilder.addInput(method.asOutput());
        operationBuilder.addInput(request.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.protocol != null) {
                    operationBuilder.setAttr("protocol", options2.protocol);
                }
                if (options2.failFast != null) {
                    operationBuilder.setAttr("fail_fast", options2.failFast);
                }
                if (options2.timeoutInMs == null) continue;
                operationBuilder.setAttr("timeout_in_ms", options2.timeoutInMs);
            }
        }
        return new Rpc(operationBuilder.build());
    }

    public static Options protocol(String protocol) {
        return new Options().protocol(protocol);
    }

    public static Options failFast(Boolean failFast) {
        return new Options().failFast(failFast);
    }

    public static Options timeoutInMs(Long timeoutInMs) {
        return new Options().timeoutInMs(timeoutInMs);
    }

    public final Output<String> response() {
        return this.response;
    }

    @Override
    public final Output<String> asOutput() {
        return this.response;
    }

    private Rpc(Operation operation) {
        super(operation);
        this.response = operation.output(0);
    }

    public static class Options {
        private String protocol;
        private Boolean failFast;
        private Long timeoutInMs;

        public Options protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Options failFast(Boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Options timeoutInMs(Long timeoutInMs) {
            this.timeoutInMs = timeoutInMs;
            return this;
        }

        private Options() {
        }
    }
}

