/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SdcaOptimizerV2
extends PrimitiveOp {
    private Output<Float> outExampleStateData;
    private List<Output<Float>> outDeltaSparseWeights;
    private List<Output<Float>> outDeltaDenseWeights;

    public static SdcaOptimizerV2 create(Scope scope, Iterable<Operand<Long>> sparseExampleIndices, Iterable<Operand<Long>> sparseFeatureIndices, Iterable<Operand<Float>> sparseFeatureValues, Iterable<Operand<Float>> denseFeatures, Operand<Float> exampleWeights, Operand<Float> exampleLabels, Iterable<Operand<Long>> sparseIndices, Iterable<Operand<Float>> sparseWeights, Iterable<Operand<Float>> denseWeights, Operand<Float> exampleStateData, String lossType, Float l1, Float l2, Long numLossPartitions, Long numInnerIterations, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SdcaOptimizerV2", scope.makeOpName("SdcaOptimizerV2"));
        operationBuilder.addInputList(Operands.asOutputs(sparseExampleIndices));
        operationBuilder.addInputList(Operands.asOutputs(sparseFeatureIndices));
        operationBuilder.addInputList(Operands.asOutputs(sparseFeatureValues));
        operationBuilder.addInputList(Operands.asOutputs(denseFeatures));
        operationBuilder.addInput(exampleWeights.asOutput());
        operationBuilder.addInput(exampleLabels.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(sparseIndices));
        operationBuilder.addInputList(Operands.asOutputs(sparseWeights));
        operationBuilder.addInputList(Operands.asOutputs(denseWeights));
        operationBuilder.addInput(exampleStateData.asOutput());
        operationBuilder.setAttr("loss_type", lossType);
        operationBuilder.setAttr("l1", l1.floatValue());
        operationBuilder.setAttr("l2", l2.floatValue());
        operationBuilder.setAttr("num_loss_partitions", numLossPartitions);
        operationBuilder.setAttr("num_inner_iterations", numInnerIterations);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.adaptive == null) continue;
                operationBuilder.setAttr("adaptive", options2.adaptive);
            }
        }
        return new SdcaOptimizerV2(operationBuilder.build());
    }

    public static Options adaptive(Boolean adaptive) {
        return new Options().adaptive(adaptive);
    }

    public final Output<Float> outExampleStateData() {
        return this.outExampleStateData;
    }

    public final List<Output<Float>> outDeltaSparseWeights() {
        return this.outDeltaSparseWeights;
    }

    public final List<Output<Float>> outDeltaDenseWeights() {
        return this.outDeltaDenseWeights;
    }

    private SdcaOptimizerV2(Operation operation) {
        super(operation);
        this.outExampleStateData = operation.output(0);
        int n2 = operation.outputListLength("out_delta_sparse_weights");
        this.outDeltaSparseWeights = Arrays.asList(operation.outputList(1, n2));
        int n3 = n2 + 1;
        int n4 = operation.outputListLength("out_delta_dense_weights");
        this.outDeltaDenseWeights = Arrays.asList(operation.outputList(n3, n4));
    }

    public static class Options {
        private Boolean adaptive;

        public Options adaptive(Boolean adaptive) {
            this.adaptive = adaptive;
            return this;
        }

        private Options() {
        }
    }
}

