/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseApplyMomentum<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> out;

    public static <T, U extends Number> SparseApplyMomentum<T> create(Scope scope, Operand<T> var, Operand<T> accum, Operand<T> lr, Operand<T> grad, Operand<U> indices, Operand<T> momentum, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SparseApplyMomentum", scope.makeOpName("SparseApplyMomentum"));
        operationBuilder.addInput(var.asOutput());
        operationBuilder.addInput(accum.asOutput());
        operationBuilder.addInput(lr.asOutput());
        operationBuilder.addInput(grad.asOutput());
        operationBuilder.addInput(indices.asOutput());
        operationBuilder.addInput(momentum.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.useLocking != null) {
                    operationBuilder.setAttr("use_locking", options2.useLocking);
                }
                if (options2.useNesterov == null) continue;
                operationBuilder.setAttr("use_nesterov", options2.useNesterov);
            }
        }
        return new SparseApplyMomentum<T>(operationBuilder.build());
    }

    public static Options useLocking(Boolean useLocking) {
        return new Options().useLocking(useLocking);
    }

    public static Options useNesterov(Boolean useNesterov) {
        return new Options().useNesterov(useNesterov);
    }

    public final Output<T> out() {
        return this.out;
    }

    @Override
    public final Output<T> asOutput() {
        return this.out;
    }

    private SparseApplyMomentum(Operation operation) {
        super(operation);
        this.out = operation.output(0);
    }

    public static class Options {
        private Boolean useLocking;
        private Boolean useNesterov;

        public Options useLocking(Boolean useLocking) {
            this.useLocking = useLocking;
            return this;
        }

        public Options useNesterov(Boolean useNesterov) {
            this.useNesterov = useNesterov;
            return this;
        }

        private Options() {
        }
    }
}

