/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseCross<T>
extends PrimitiveOp {
    private Output<Long> outputIndices;
    private Output<T> outputValues;
    private Output<Long> outputShape;

    public static <T, U> SparseCross<T> create(Scope scope, Iterable<Operand<Long>> indices, Iterable<Operand<?>> values, Iterable<Operand<Long>> shapes, Iterable<Operand<?>> denseInputs, Boolean hashedOutput, Long numBuckets, Long hashKey, Class<T> outType, Class<U> internalType) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SparseCross", scope.makeOpName("SparseCross"));
        operationBuilder.addInputList(Operands.asOutputs(indices));
        operationBuilder.addInputList(Operands.asOutputs(values));
        operationBuilder.addInputList(Operands.asOutputs(shapes));
        operationBuilder.addInputList(Operands.asOutputs(denseInputs));
        operationBuilder.setAttr("hashed_output", hashedOutput);
        operationBuilder.setAttr("num_buckets", numBuckets);
        operationBuilder.setAttr("hash_key", hashKey);
        operationBuilder.setAttr("out_type", DataType.fromClass(outType));
        operationBuilder.setAttr("internal_type", DataType.fromClass(internalType));
        return new SparseCross<T>(operationBuilder.build());
    }

    public final Output<Long> outputIndices() {
        return this.outputIndices;
    }

    public final Output<T> outputValues() {
        return this.outputValues;
    }

    public final Output<Long> outputShape() {
        return this.outputShape;
    }

    private SparseCross(Operation operation) {
        super(operation);
        this.outputIndices = operation.output(0);
        this.outputValues = operation.output(1);
        this.outputShape = operation.output(2);
    }
}

