/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TensorArray
extends PrimitiveOp {
    private Output<?> handle;
    private Output<Float> flow;

    public static <T> TensorArray create(Scope scope, Operand<Integer> size, Class<T> dtype, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("TensorArrayV3", scope.makeOpName("TensorArray"));
        operationBuilder.addInput(size.asOutput());
        operationBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.elementShape != null) {
                    operationBuilder.setAttr("element_shape", options2.elementShape);
                }
                if (options2.dynamicSize != null) {
                    operationBuilder.setAttr("dynamic_size", options2.dynamicSize);
                }
                if (options2.clearAfterRead != null) {
                    operationBuilder.setAttr("clear_after_read", options2.clearAfterRead);
                }
                if (options2.identicalElementShapes != null) {
                    operationBuilder.setAttr("identical_element_shapes", options2.identicalElementShapes);
                }
                if (options2.tensorArrayName == null) continue;
                operationBuilder.setAttr("tensor_array_name", options2.tensorArrayName);
            }
        }
        return new TensorArray(operationBuilder.build());
    }

    public static Options elementShape(Shape elementShape) {
        return new Options().elementShape(elementShape);
    }

    public static Options dynamicSize(Boolean dynamicSize) {
        return new Options().dynamicSize(dynamicSize);
    }

    public static Options clearAfterRead(Boolean clearAfterRead) {
        return new Options().clearAfterRead(clearAfterRead);
    }

    public static Options identicalElementShapes(Boolean identicalElementShapes) {
        return new Options().identicalElementShapes(identicalElementShapes);
    }

    public static Options tensorArrayName(String tensorArrayName) {
        return new Options().tensorArrayName(tensorArrayName);
    }

    public final Output<?> handle() {
        return this.handle;
    }

    public final Output<Float> flow() {
        return this.flow;
    }

    private TensorArray(Operation operation) {
        super(operation);
        this.handle = operation.output(0);
        this.flow = operation.output(1);
    }

    public static class Options {
        private Shape elementShape;
        private Boolean dynamicSize;
        private Boolean clearAfterRead;
        private Boolean identicalElementShapes;
        private String tensorArrayName;

        public Options elementShape(Shape elementShape) {
            this.elementShape = elementShape;
            return this;
        }

        public Options dynamicSize(Boolean dynamicSize) {
            this.dynamicSize = dynamicSize;
            return this;
        }

        public Options clearAfterRead(Boolean clearAfterRead) {
            this.clearAfterRead = clearAfterRead;
            return this;
        }

        public Options identicalElementShapes(Boolean identicalElementShapes) {
            this.identicalElementShapes = identicalElementShapes;
            return this;
        }

        public Options tensorArrayName(String tensorArrayName) {
            this.tensorArrayName = tensorArrayName;
            return this;
        }

        private Options() {
        }
    }
}

