/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TensorArrayConcat<T>
extends PrimitiveOp {
    private Output<T> value;
    private Output<Long> lengths;

    public static <T> TensorArrayConcat<T> create(Scope scope, Operand<?> handle, Operand<Float> flowIn, Class<T> dtype, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("TensorArrayConcatV3", scope.makeOpName("TensorArrayConcat"));
        operationBuilder.addInput(handle.asOutput());
        operationBuilder.addInput(flowIn.asOutput());
        operationBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.elementShapeExcept0 == null) continue;
                operationBuilder.setAttr("element_shape_except0", options2.elementShapeExcept0);
            }
        }
        return new TensorArrayConcat<T>(operationBuilder.build());
    }

    public static Options elementShapeExcept0(Shape elementShapeExcept0) {
        return new Options().elementShapeExcept0(elementShapeExcept0);
    }

    public final Output<T> value() {
        return this.value;
    }

    public final Output<Long> lengths() {
        return this.lengths;
    }

    private TensorArrayConcat(Operation operation) {
        super(operation);
        this.value = operation.output(0);
        this.lengths = operation.output(1);
    }

    public static class Options {
        private Shape elementShapeExcept0;

        public Options elementShapeExcept0(Shape elementShapeExcept0) {
            this.elementShapeExcept0 = elementShapeExcept0;
            return this;
        }

        private Options() {
        }
    }
}

