/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TensorArrayGather<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> value;

    public static <T> TensorArrayGather<T> create(Scope scope, Operand<?> handle, Operand<Integer> indices, Operand<Float> flowIn, Class<T> dtype, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("TensorArrayGatherV3", scope.makeOpName("TensorArrayGather"));
        operationBuilder.addInput(handle.asOutput());
        operationBuilder.addInput(indices.asOutput());
        operationBuilder.addInput(flowIn.asOutput());
        operationBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.elementShape == null) continue;
                operationBuilder.setAttr("element_shape", options2.elementShape);
            }
        }
        return new TensorArrayGather<T>(operationBuilder.build());
    }

    public static Options elementShape(Shape elementShape) {
        return new Options().elementShape(elementShape);
    }

    public final Output<T> value() {
        return this.value;
    }

    @Override
    public final Output<T> asOutput() {
        return this.value;
    }

    private TensorArrayGather(Operation operation) {
        super(operation);
        this.value = operation.output(0);
    }

    public static class Options {
        private Shape elementShape;

        public Options elementShape(Shape elementShape) {
            this.elementShape = elementShape;
            return this;
        }

        private Options() {
        }
    }
}

