/*
 * Decompiled with CFR 0.152.
 */
package picocli;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import picocli.CommandLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoComplete {
    public static final int EXIT_CODE_SUCCESS = 0;
    public static final int EXIT_CODE_INVALID_INPUT = 1;
    public static final int EXIT_CODE_COMMAND_SCRIPT_EXISTS = 2;
    public static final int EXIT_CODE_COMPLETION_SCRIPT_EXISTS = 3;
    public static final int EXIT_CODE_EXECUTION_ERROR = 4;
    private static final String SCRIPT_HEADER = "#!/usr/bin/env bash\n#\n# %1$s Bash Completion\n# =======================\n#\n# Bash completion support for the `%1$s` command,\n# generated by [picocli](http://picocli.info/) version %2$s.\n#\n# Installation\n# ------------\n#\n# 1. Source all completion scripts in your .bash_profile\n#\n#   cd $YOUR_APP_HOME/bin\n#   for f in $(find . -name \"*_completion\"); do line=\". $(pwd)/$f\"; grep \"$line\" ~/.bash_profile || echo \"$line\" >> ~/.bash_profile; done\n#\n# 2. Open a new bash console, and type `%1$s [TAB][TAB]`\n#\n# 1a. Alternatively, if you have [bash-completion](https://github.com/scop/bash-completion) installed:\n#     Place this file in a `bash-completion.d` folder:\n#\n#   * /etc/bash-completion.d\n#   * /usr/local/etc/bash-completion.d\n#   * ~/bash-completion.d\n#\n# Documentation\n# -------------\n# The script is called by bash whenever [TAB] or [TAB][TAB] is pressed after\n# '%1$s (..)'. By reading entered command line parameters,\n# it determines possible bash completions and writes them to the COMPREPLY variable.\n# Bash then completes the user input if only one entry is listed in the variable or\n# shows the options if more than one is listed in COMPREPLY.\n#\n# References\n# ----------\n# [1] http://stackoverflow.com/a/12495480/1440785\n# [2] http://tiswww.case.edu/php/chet/bash/FAQ\n# [3] https://www.gnu.org/software/bash/manual/html_node/The-Shopt-Builtin.html\n# [4] http://zsh.sourceforge.net/Doc/Release/Options.html#index-COMPLETE_005fALIASES\n# [5] https://stackoverflow.com/questions/17042057/bash-check-element-in-array-for-elements-in-another-array/17042655#17042655\n# [6] https://www.gnu.org/software/bash/manual/html_node/Programmable-Completion.html#Programmable-Completion\n# [7] https://stackoverflow.com/questions/3249432/can-a-bash-tab-completion-script-be-used-in-zsh/27853970#27853970\n#\n\nif [ -n \"$BASH_VERSION\" ]; then\n  # Enable programmable completion facilities when using bash (see [3])\n  shopt -s progcomp\nelif [ -n \"$ZSH_VERSION\" ]; then\n  # Make alias a distinct command for completion purposes when using zsh (see [4])\n  setopt COMPLETE_ALIASES\n  alias compopt=complete\n\n  # Enable bash completion in zsh (see [7])\n  autoload -U +X compinit && compinit\n  autoload -U +X bashcompinit && bashcompinit\nfi\n\n# CompWordsContainsArray takes an array and then checks\n# if all elements of this array are in the global COMP_WORDS array.\n#\n# Returns zero (no error) if all elements of the array are in the COMP_WORDS array,\n# otherwise returns 1 (error).\nfunction CompWordsContainsArray() {\n  declare -a localArray\n  localArray=(\"$@\")\n  local findme\n  for findme in \"${localArray[@]}\"; do\n    if ElementNotInCompWords \"$findme\"; then return 1; fi\n  done\n  return 0\n}\nfunction ElementNotInCompWords() {\n  local findme=\"$1\"\n  local element\n  for element in \"${COMP_WORDS[@]}\"; do\n    if [[ \"$findme\" = \"$element\" ]]; then return 1; fi\n  done\n  return 0\n}\n\n# The `currentPositionalIndex` function calculates the index of the current positional parameter.\n#\n# currentPositionalIndex takes three parameters:\n# the command name,\n# a space-separated string with the names of options that take a parameter, and\n# a space-separated string with the names of boolean options (that don't take any params).\n# When done, this function echos the current positional index to std_out.\n#\n# Example usage:\n# local currIndex=$(currentPositionalIndex \"mysubcommand\" \"$ARG_OPTS\" \"$FLAG_OPTS\")\nfunction currentPositionalIndex() {\n  local commandName=\"$1\"\n  local optionsWithArgs=\"$2\"\n  local booleanOptions=\"$3\"\n  local previousWord\n  local result=0\n\n  for i in $(seq $((COMP_CWORD - 1)) -1 0); do\n    previousWord=${COMP_WORDS[i]}\n    if [ \"${previousWord}\" = \"$commandName\" ]; then\n      break\n    fi\n    if [[ \"${optionsWithArgs}\" =~ ${previousWord} ]]; then\n      ((result-=2)) # Arg option and its value not counted as positional param\n    elif [[ \"${booleanOptions}\" =~ ${previousWord} ]]; then\n      ((result-=1)) # Flag option itself not counted as positional param\n    fi\n    ((result++))\n  done\n  echo \"$result\"\n}\n\n";
    private static final String SCRIPT_FOOTER = "\n# Define a completion specification (a compspec) for the\n# `%1$s`, `%1$s.sh`, and `%1$s.bash` commands.\n# Uses the bash `complete` builtin (see [6]) to specify that shell function\n# `_complete_%1$s` is responsible for generating possible completions for the\n# current word on the command line.\n# The `-o default` option means that if the function generated no matches, the\n# default Bash completions and the Readline default filename completions are performed.\ncomplete -F _complete_%1$s -o default %1$s %1$s.sh %1$s.bash\n";

    private AutoComplete() {
    }

    public static void main(String ... args) {
        CommandLine.IExecutionExceptionHandler iExecutionExceptionHandler = new CommandLine.IExecutionExceptionHandler(){

            public final int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) {
                ex.printStackTrace();
                CommandLine commandLine2 = commandLine;
                commandLine2.usage(commandLine2.getErr());
                return 4;
            }
        };
        int n2 = new CommandLine(new App()).setExecutionExceptionHandler(iExecutionExceptionHandler).execute(args);
        if (n2 == 0 && AutoComplete.exitOnSuccess() || n2 != 0 && AutoComplete.exitOnError()) {
            System.exit(n2);
        }
    }

    private static boolean exitOnSuccess() {
        return AutoComplete.syspropDefinedAndNotFalse("picocli.autocomplete.systemExitOnSuccess");
    }

    private static boolean exitOnError() {
        return AutoComplete.syspropDefinedAndNotFalse("picocli.autocomplete.systemExitOnError");
    }

    private static boolean syspropDefinedAndNotFalse(String key) {
        String string = System.getProperty(key);
        return string != null && !"false".equalsIgnoreCase(string);
    }

    private static String bashify(CharSequence value) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < value.length(); ++i2) {
            char c2 = value.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '_') {
                stringBuilder.append(c2);
                continue;
            }
            if (!Character.isSpaceChar(c2)) continue;
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    private static <T> Predicate<T> negate(final Predicate<T> original) {
        return new Predicate<T>(){

            @Override
            public final boolean test(T t2) {
                return !original.test(t2);
            }
        };
    }

    private static <K, T extends K> List<T> filter(List<T> list, Predicate<K> filter) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : list) {
            if (!filter.test(t2)) continue;
            arrayList.add(t2);
        }
        return arrayList;
    }

    public static void bash(String scriptName, File out, File command, CommandLine commandLine) throws IOException {
        Writer writer;
        FileWriter fileWriter;
        block5: {
            String string = AutoComplete.bash(scriptName, commandLine);
            fileWriter = null;
            writer = null;
            try {
                fileWriter = new FileWriter(out);
                fileWriter.write(string);
                if (command == null) break block5;
                writer = new FileWriter(command);
                writer.write("#!/usr/bin/env bash\n\nLIBS=path/to/libs\nCP=\"${LIBS}/myApp.jar\"\njava -cp \"${CP}\" '" + commandLine.getCommand().getClass().getName() + "' $@");
            }
            catch (Throwable throwable) {
                if (fileWriter != null) {
                    ((Writer)fileWriter).close();
                }
                if (writer != null) {
                    writer.close();
                }
                throw throwable;
            }
        }
        ((Writer)fileWriter).close();
        if (writer != null) {
            writer.close();
            return;
        }
    }

    public static String bash(String scriptName, CommandLine commandLine) {
        if (scriptName == null) {
            throw new NullPointerException("scriptName");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format(SCRIPT_HEADER, scriptName, "4.5.1"));
        LinkedHashMap<CommandDescriptor, CommandLine> linkedHashMap = new LinkedHashMap<CommandDescriptor, CommandLine>();
        stringBuilder.append(AutoComplete.generateEntryPointFunction(scriptName, commandLine, linkedHashMap));
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            if (((CommandLine)entry.getValue()).getCommandSpec().usageMessage().hidden()) continue;
            CommandDescriptor commandDescriptor = (CommandDescriptor)entry.getKey();
            stringBuilder.append(AutoComplete.generateFunctionForCommand(commandDescriptor.functionName, commandDescriptor.commandName, (CommandLine)entry.getValue()));
        }
        stringBuilder.append(String.format(SCRIPT_FOOTER, scriptName));
        return stringBuilder.toString();
    }

    private static String generateEntryPointFunction(String scriptName, CommandLine commandLine, Map<CommandDescriptor, CommandLine> function2command) {
        String string = "# Bash completion entry point function.\n# _complete_%1$s finds which commands and subcommands have been specified\n# on the command line and delegates to the appropriate function\n# to generate possible options and subcommands for the last specified subcommand.\nfunction _complete_%1$s() {\n";
        String string2 = "\n  # No subcommands were specified; generate completions for the top-level command.\n  _picocli_%1$s; return $?;\n}\n";
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append(String.format(string, scriptName));
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        function2command.put(new CommandDescriptor("_picocli_" + scriptName, scriptName), commandLine);
        AutoComplete.generateFunctionCallsToArrContains(scriptName, arrayList, commandLine, stringBuilder, arrayList2, function2command);
        stringBuilder.append("\n");
        Collections.reverse(arrayList2);
        for (String string3 : arrayList2) {
            stringBuilder.append(string3);
        }
        stringBuilder.append(String.format(string2, scriptName));
        return stringBuilder.toString();
    }

    private static void generateFunctionCallsToArrContains(String scriptName, List<String> predecessors, CommandLine commandLine, StringBuilder buff, List<String> functionCalls, Map<CommandDescriptor, CommandLine> function2command) {
        for (Map.Entry<String, CommandLine> entry : commandLine.getSubcommands().entrySet()) {
            if (entry.getValue().getCommandSpec().usageMessage().hidden()) continue;
            int n2 = functionCalls.size();
            String string = "_picocli_" + scriptName + "_" + AutoComplete.concat("_", predecessors, entry.getKey(), new Bashify());
            functionCalls.add(String.format("  if CompWordsContainsArray \"${cmds%2$d[@]}\"; then %1$s; return $?; fi\n", string, n2));
            buff.append(String.format("  local cmds%2$d=(%1$s)\n", AutoComplete.concat(" ", predecessors, entry.getKey(), new NullFunction()), n2));
            function2command.put(new CommandDescriptor(string, entry.getKey()), entry.getValue());
        }
        for (Map.Entry<String, CommandLine> entry : commandLine.getSubcommands().entrySet()) {
            if (entry.getValue().getCommandSpec().usageMessage().hidden()) continue;
            predecessors.add(entry.getKey());
            AutoComplete.generateFunctionCallsToArrContains(scriptName, predecessors, entry.getValue(), buff, functionCalls, function2command);
            List<String> list = predecessors;
            list.remove(list.size() - 1);
        }
    }

    private static String concat(String infix, String ... values) {
        return AutoComplete.concat(infix, Arrays.asList(values));
    }

    private static String concat(String infix, List<String> values) {
        return AutoComplete.concat(infix, values, null, new NullFunction());
    }

    private static <V, T extends V> String concat(String infix, List<T> values, T lastValue, Function<V, String> normalize) {
        StringBuilder stringBuilder = new StringBuilder();
        for (T t2 : values) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(infix);
            }
            stringBuilder.append(normalize.apply(t2));
        }
        if (lastValue == null) {
            return stringBuilder.toString();
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(infix);
        }
        return stringBuilder.append(normalize.apply(lastValue)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String generateFunctionForCommand(String functionName, String commandName, CommandLine commandLine) {
        void var15_23;
        String string = "\n# Generates completions for the options and subcommands of the `%s` %scommand.\nfunction %s() {\n  # Get completion data\n  local curr_word=${COMP_WORDS[COMP_CWORD]}\n%s\n  local commands=\"%s\"\n  local flag_opts=\"%s\"\n  local arg_opts=\"%s\"\n";
        String string2 = "\n  if [[ \"${curr_word}\" == -* ]]; then\n    COMPREPLY=( $(compgen -W \"${flag_opts} ${arg_opts}\" -- \"${curr_word}\") )\n  else\n    local positionals=\"\"\n%s    COMPREPLY=( $(compgen -W \"${commands} ${positionals}\" -- \"${curr_word}\") )\n  fi\n}\n";
        CommandLine.Model.CommandSpec commandSpec = commandLine.getCommandSpec();
        String string3 = AutoComplete.optionNames(AutoComplete.filter(commandSpec.options(), new BooleanArgFilter()));
        List<CommandLine.Model.OptionSpec> list = AutoComplete.filter(commandSpec.options(), AutoComplete.negate(new BooleanArgFilter()));
        String string4 = AutoComplete.optionNames(list);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String object22 : commandLine.getSubcommands().keySet()) {
            if (commandLine.getSubcommands().get(object22).getCommandSpec().usageMessage().hidden()) continue;
            linkedHashSet.add(object22);
        }
        if (commandLine.getParent() != null && commandLine.getCommand() instanceof CommandLine.HelpCommand) {
            linkedHashSet = new LinkedHashSet(linkedHashSet);
            for (CommandLine commandLine2 : commandLine.getParent().getSubcommands().values()) {
                if (commandLine == commandLine2 || commandLine2.getCommandSpec().usageMessage().hidden()) continue;
                linkedHashSet.add(commandLine2.getCommandName());
            }
        }
        Iterator<CommandLine> iterator = AutoComplete.concat(" ", new ArrayList<String>(linkedHashSet)).trim();
        StringBuilder stringBuilder = new StringBuilder(1024);
        String string5 = functionName.equals("_picocli_" + commandName) ? "" : "sub";
        String string6 = list.isEmpty() ? "" : "  local prev_word=${COMP_WORDS[COMP_CWORD-1]}\n";
        stringBuilder.append(String.format(string, commandName, string5, functionName, string6, iterator, string3, string4));
        for (CommandLine.Model.OptionSpec optionSpec : commandSpec.options()) {
            if (optionSpec.hidden() || optionSpec.completionCandidates() == null) continue;
            AutoComplete.generateCompletionCandidates(stringBuilder, optionSpec);
        }
        stringBuilder.append(AutoComplete.generateOptionsSwitch(list));
        for (CommandLine.Model.PositionalParamSpec positionalParamSpec : commandSpec.positionalParameters()) {
            if (positionalParamSpec.completionCandidates() == null) continue;
            AutoComplete.generatePositionParamCompletionCandidates(stringBuilder, positionalParamSpec);
        }
        String string7 = AutoComplete.generatePositionalParamsCases(commandSpec.positionalParameters(), "", "${curr_word}");
        String string8 = "";
        if (string7.length() > 0) {
            String string9 = "    local currIndex\n    currIndex=$(currentPositionalIndex \"%s\" \"${arg_opts}\" \"${flag_opts}\")\n%s";
            String string10 = String.format("    local currIndex\n    currIndex=$(currentPositionalIndex \"%s\" \"${arg_opts}\" \"${flag_opts}\")\n%s", commandName, string7);
        }
        stringBuilder.append(String.format(string2, var15_23));
        return stringBuilder.toString();
    }

    private static void generatePositionParamCompletionCandidates(StringBuilder buff, CommandLine.Model.PositionalParamSpec f2) {
        String string = AutoComplete.bashify(f2.paramLabel());
        buff.append(String.format("  local %s_pos_param_args=\"%s\" # %d-%d values\n", string, AutoComplete.concat(" ", AutoComplete.extract(f2.completionCandidates())).trim(), f2.index().min(), f2.index().max()));
    }

    private static void generateCompletionCandidates(StringBuilder buff, CommandLine.Model.OptionSpec f2) {
        buff.append(String.format("  local %s_option_args=\"%s\" # %s values\n", AutoComplete.bashify(f2.paramLabel()), AutoComplete.concat(" ", AutoComplete.extract(f2.completionCandidates())).trim(), f2.longestName()));
    }

    private static List<String> extract(Iterable<String> generator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : generator) {
            arrayList.add(string);
        }
        return arrayList;
    }

    private static String generatePositionalParamsCases(List<CommandLine.Model.PositionalParamSpec> posParams, String indent, String currWord) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (CommandLine.Model.PositionalParamSpec positionalParamSpec : posParams) {
            if (positionalParamSpec.hidden()) continue;
            Class<?> clazz = positionalParamSpec.type();
            if (positionalParamSpec.typeInfo().isMultiValue()) {
                clazz = positionalParamSpec.typeInfo().getAuxiliaryTypes()[0];
            }
            String string = AutoComplete.bashify(positionalParamSpec.paramLabel());
            String string2 = stringBuilder.length() > 0 ? "elif" : "if";
            int n2 = positionalParamSpec.index().min();
            int n3 = positionalParamSpec.index().max();
            if (positionalParamSpec.completionCandidates() != null) {
                stringBuilder.append(String.format("%s    %s (( currIndex >= %d && currIndex <= %d )); then\n", indent, string2, n2, n3));
                stringBuilder.append(String.format("%s      positionals=$( compgen -W \"$%s_pos_param_args\" -- \"%s\" )\n", indent, string, currWord));
                continue;
            }
            if (clazz.equals(File.class) || "java.nio.file.Path".equals(clazz.getName())) {
                stringBuilder.append(String.format("%s    %s (( currIndex >= %d && currIndex <= %d )); then\n", indent, string2, n2, n3));
                stringBuilder.append(String.format("%s      compopt -o filenames\n", indent));
                stringBuilder.append(String.format("%s      positionals=$( compgen -f -- \"%s\" ) # files\n", indent, currWord));
                continue;
            }
            if (!clazz.equals(InetAddress.class)) continue;
            stringBuilder.append(String.format("%s    %s (( currIndex >= %d && currIndex <= %d )); then\n", indent, string2, n2, n3));
            stringBuilder.append(String.format("%s      compopt -o filenames\n", indent));
            stringBuilder.append(String.format("%s      positionals=$( compgen -A hostname -- \"%s\" )\n", indent, currWord));
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(String.format("%s    fi\n", indent));
        }
        return stringBuilder.toString();
    }

    private static String generateOptionsSwitch(List<CommandLine.Model.OptionSpec> argOptions) {
        String string = AutoComplete.generateOptionsCases(argOptions, "", "${curr_word}");
        if (string.length() == 0) {
            return "";
        }
        return "\n  compopt +o default\n\n  case ${prev_word} in\n" + string + "  esac\n";
    }

    private static String generateOptionsCases(List<CommandLine.Model.OptionSpec> argOptionFields, String indent, String currWord) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (CommandLine.Model.OptionSpec optionSpec : argOptionFields) {
            if (optionSpec.hidden()) continue;
            Class<?> clazz = optionSpec.type();
            if (optionSpec.typeInfo().isMultiValue()) {
                clazz = optionSpec.typeInfo().getAuxiliaryTypes()[0];
            }
            if (optionSpec.completionCandidates() != null) {
                stringBuilder.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", optionSpec.names())));
                stringBuilder.append(String.format("%s      COMPREPLY=( $( compgen -W \"${%s_option_args}\" -- \"%s\" ) )\n", indent, AutoComplete.bashify(optionSpec.paramLabel()), currWord));
                stringBuilder.append(String.format("%s      return $?\n", indent));
                stringBuilder.append(String.format("%s      ;;\n", indent));
                continue;
            }
            if (clazz.equals(File.class) || "java.nio.file.Path".equals(clazz.getName())) {
                stringBuilder.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", optionSpec.names())));
                stringBuilder.append(String.format("%s      compopt -o filenames\n", indent));
                stringBuilder.append(String.format("%s      COMPREPLY=( $( compgen -f -- \"%s\" ) ) # files\n", indent, currWord));
                stringBuilder.append(String.format("%s      return $?\n", indent));
                stringBuilder.append(String.format("%s      ;;\n", indent));
                continue;
            }
            if (clazz.equals(InetAddress.class)) {
                stringBuilder.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", optionSpec.names())));
                stringBuilder.append(String.format("%s      compopt -o filenames\n", indent));
                stringBuilder.append(String.format("%s      COMPREPLY=( $( compgen -A hostname -- \"%s\" ) )\n", indent, currWord));
                stringBuilder.append(String.format("%s      return $?\n", indent));
                stringBuilder.append(String.format("%s      ;;\n", indent));
                continue;
            }
            stringBuilder.append(String.format("%s    %s)\n", indent, AutoComplete.concat("|", optionSpec.names())));
            stringBuilder.append(String.format("%s      return\n", indent));
            stringBuilder.append(String.format("%s      ;;\n", indent));
        }
        return stringBuilder.toString();
    }

    private static String optionNames(List<CommandLine.Model.OptionSpec> options) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CommandLine.Model.OptionSpec optionSpec : options) {
            if (optionSpec.hidden()) continue;
            arrayList.addAll(Arrays.asList(optionSpec.names()));
        }
        return AutoComplete.concat(" ", arrayList, "", new NullFunction()).trim();
    }

    public static int complete(CommandLine.Model.CommandSpec spec, String[] args, int argIndex, int positionInArg, int cursor, List<CharSequence> candidates) {
        Object object;
        if (spec == null) {
            throw new NullPointerException("spec is null");
        }
        if (args == null) {
            throw new NullPointerException("args is null");
        }
        if (candidates == null) {
            throw new NullPointerException("candidates list is null");
        }
        if (argIndex == args.length) {
            object = new String[args.length + 1];
            System.arraycopy(args, 0, object, 0, args.length);
            args = object;
            object[argIndex] = "";
        }
        if (argIndex < 0 || argIndex >= args.length) {
            throw new IllegalArgumentException("Invalid argIndex " + argIndex + ": args array only has " + args.length + " elements.");
        }
        if (positionInArg < 0 || positionInArg > args[argIndex].length()) {
            throw new IllegalArgumentException("Invalid positionInArg " + positionInArg + ": args[" + argIndex + "] (" + args[argIndex] + ") only has " + args[argIndex].length() + " characters.");
        }
        object = args[argIndex];
        boolean bl = spec.parser().collectErrors();
        try {
            Object object2;
            String string = ((String)object).substring(0, positionInArg);
            spec.parser().collectErrors(true);
            CommandLine commandLine = new CommandLine(spec);
            CommandLine.ParseResult parseResult = commandLine.parseArgs(args);
            if (argIndex >= parseResult.tentativeMatch.size()) {
                object2 = AutoComplete.findCompletionStartPoint(parseResult);
                AutoComplete.addCandidatesForArgsFollowing(object2, candidates);
            } else {
                object2 = parseResult.tentativeMatch.get(argIndex);
                if (object2 instanceof CommandLine.Model.CommandSpec) {
                    AutoComplete.addCandidatesForArgsFollowing(((CommandLine.Model.CommandSpec)object2).parent(), candidates);
                } else if (object2 instanceof CommandLine.Model.OptionSpec) {
                    int n2 = ((String)object).indexOf(spec.parser().separator());
                    if (n2 < 0 || positionInArg < n2) {
                        AutoComplete.addCandidatesForArgsFollowing(AutoComplete.findCommandFor((CommandLine.Model.OptionSpec)object2, spec), candidates);
                    } else {
                        AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.OptionSpec)object2, candidates);
                        int n3 = spec.parser().separator().length();
                        if (positionInArg < n2 + n3) {
                            int n4 = positionInArg - n2;
                            String string2 = spec.parser().separator().substring(n4);
                            for (int i2 = 0; i2 < candidates.size(); ++i2) {
                                candidates.set(i2, string2 + candidates.get(i2));
                            }
                            string = ((String)object).substring(n2, positionInArg);
                        } else {
                            string = ((String)object).substring(n2 + n3, positionInArg);
                        }
                    }
                } else if (object2 instanceof CommandLine.Model.PositionalParamSpec) {
                    AutoComplete.addCandidatesForArgsFollowing(AutoComplete.findCommandFor((CommandLine.Model.PositionalParamSpec)object2, spec), candidates);
                } else {
                    int n5;
                    for (n5 = argIndex - 1; n5 > 0 && !AutoComplete.isPicocliModelObject(parseResult.tentativeMatch.get(n5)); --n5) {
                    }
                    if (n5 < 0) {
                        return -1;
                    }
                    AutoComplete.addCandidatesForArgsFollowing(parseResult.tentativeMatch.get(n5), candidates);
                }
            }
            AutoComplete.filterAndTrimMatchingPrefix(string, candidates);
            int n6 = candidates.isEmpty() ? -1 : cursor;
            return n6;
        }
        finally {
            spec.parser().collectErrors(bl);
        }
    }

    private static Object findCompletionStartPoint(CommandLine.ParseResult parseResult) {
        List<Object> list = parseResult.tentativeMatch;
        for (int i2 = 1; i2 <= list.size(); ++i2) {
            List<Object> list2 = list;
            Object object = list2.get(list2.size() - i2);
            if (object instanceof CommandLine.Model.CommandSpec) {
                return object;
            }
            if (!(object instanceof CommandLine.Model.ArgSpec)) continue;
            CommandLine.Range range = ((CommandLine.Model.ArgSpec)object).arity();
            if (i2 < range.min()) {
                return object;
            }
            return AutoComplete.findCommandFor((CommandLine.Model.ArgSpec)object, parseResult.commandSpec());
        }
        return parseResult.commandSpec();
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.ArgSpec arg, CommandLine.Model.CommandSpec cmd) {
        if (arg instanceof CommandLine.Model.OptionSpec) {
            return AutoComplete.findCommandFor((CommandLine.Model.OptionSpec)arg, cmd);
        }
        return AutoComplete.findCommandFor((CommandLine.Model.PositionalParamSpec)arg, cmd);
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.OptionSpec option, CommandLine.Model.CommandSpec commandSpec) {
        for (CommandLine.Model.OptionSpec object : commandSpec.options()) {
            if (object != option) continue;
            return commandSpec;
        }
        for (CommandLine commandLine : commandSpec.subcommands().values()) {
            CommandLine.Model.CommandSpec commandSpec2 = AutoComplete.findCommandFor(option, commandLine.getCommandSpec());
            if (commandSpec2 == null) continue;
            return commandSpec2;
        }
        return null;
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.PositionalParamSpec positional, CommandLine.Model.CommandSpec commandSpec) {
        for (CommandLine.Model.PositionalParamSpec object : commandSpec.positionalParameters()) {
            if (object != positional) continue;
            return commandSpec;
        }
        for (CommandLine commandLine : commandSpec.subcommands().values()) {
            CommandLine.Model.CommandSpec commandSpec2 = AutoComplete.findCommandFor(positional, commandLine.getCommandSpec());
            if (commandSpec2 == null) continue;
            return commandSpec2;
        }
        return null;
    }

    private static boolean isPicocliModelObject(Object obj) {
        return obj instanceof CommandLine.Model.CommandSpec || obj instanceof CommandLine.Model.OptionSpec || obj instanceof CommandLine.Model.PositionalParamSpec;
    }

    private static void filterAndTrimMatchingPrefix(String prefix, List<CharSequence> candidates) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        for (CharSequence charSequence : candidates) {
            if (!charSequence.toString().startsWith(prefix)) continue;
            arrayList.add(charSequence.subSequence(prefix.length(), charSequence.length()));
        }
        candidates.clear();
        candidates.addAll(arrayList);
    }

    private static void addCandidatesForArgsFollowing(Object obj, List<CharSequence> candidates) {
        if (obj == null) {
            return;
        }
        if (obj instanceof CommandLine.Model.CommandSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.CommandSpec)obj, candidates);
            return;
        }
        if (obj instanceof CommandLine.Model.OptionSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.OptionSpec)obj, candidates);
            return;
        }
        if (obj instanceof CommandLine.Model.PositionalParamSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.PositionalParamSpec)obj, candidates);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.CommandSpec commandSpec, List<CharSequence> candidates) {
        if (commandSpec == null) {
            return;
        }
        for (Map.Entry<String, CommandLine> object : commandSpec.subcommands().entrySet()) {
            if (object.getValue().getCommandSpec().usageMessage().hidden()) continue;
            candidates.add(object.getKey());
            candidates.addAll(Arrays.asList(object.getValue().getCommandSpec().aliases()));
        }
        candidates.addAll(commandSpec.optionsMap().keySet());
        for (CommandLine.Model.PositionalParamSpec positionalParamSpec : commandSpec.positionalParameters()) {
            if (positionalParamSpec.hidden()) continue;
            AutoComplete.addCandidatesForArgsFollowing(positionalParamSpec, candidates);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.OptionSpec optionSpec, List<CharSequence> candidates) {
        if (optionSpec != null && !optionSpec.hidden()) {
            AutoComplete.addCompletionCandidates(optionSpec.completionCandidates(), candidates);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.PositionalParamSpec positionalSpec, List<CharSequence> candidates) {
        if (positionalSpec != null && !positionalSpec.hidden()) {
            AutoComplete.addCompletionCandidates(positionalSpec.completionCandidates(), candidates);
        }
    }

    private static void addCompletionCandidates(Iterable<String> completionCandidates, List<CharSequence> candidates) {
        if (completionCandidates != null) {
            for (String string : completionCandidates) {
                candidates.add(string);
            }
        }
    }

    static class CommandDescriptor {
        final String functionName;
        final String commandName;

        CommandDescriptor(String functionName, String commandName) {
            this.functionName = functionName;
            this.commandName = commandName;
        }

        public int hashCode() {
            return this.functionName.hashCode() * 37 + this.commandName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CommandDescriptor)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            CommandDescriptor commandDescriptor = (CommandDescriptor)obj;
            return commandDescriptor.functionName.equals(this.functionName) && commandDescriptor.commandName.equals(this.commandName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanArgFilter
    implements Predicate<CommandLine.Model.ArgSpec> {
        private BooleanArgFilter() {
        }

        @Override
        public boolean test(CommandLine.Model.ArgSpec f2) {
            return f2.type() == Boolean.TYPE || f2.type() == Boolean.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Predicate<T> {
        public boolean test(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullFunction
    implements Function<CharSequence, String> {
        private NullFunction() {
        }

        @Override
        public String apply(CharSequence value) {
            return value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Bashify
    implements Function<CharSequence, String> {
        private Bashify() {
        }

        @Override
        public String apply(CharSequence value) {
            return AutoComplete.bashify(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Function<T, V> {
        public V apply(T var1);
    }

    @CommandLine.Command(name="generate-completion", version={"generate-completion 4.5.1"}, mixinStandardHelpOptions=true, description={"Generate bash/zsh completion script for ${ROOT-COMMAND-NAME:-the root command of this command}.", "Run the following command to give `${ROOT-COMMAND-NAME:-$PARENTCOMMAND}` TAB completion in the current shell:", "", "  source <(${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME})", ""}, optionListHeading="Options:%n", helpCommand=true)
    public static class GenerateCompletion
    implements Runnable {
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;

        public void run() {
            String string = AutoComplete.bash(this.spec.root().name(), this.spec.root().commandLine());
            this.spec.commandLine().getOut().print(string);
            this.spec.commandLine().getOut().print('\n');
            this.spec.commandLine().getOut().flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @CommandLine.Command(name="picocli.AutoComplete", mixinStandardHelpOptions=true, showAtFileInUsageHelp=true, version={"picocli.AutoComplete 4.5.1"}, sortOptions=false, description={"Generates a bash completion script for the specified command class."}, footerHeading="%n@|bold System Properties:|@%n", footer={"Set the following system properties to control the exit code of this program:", "", "* `\"@|yellow picocli.autocomplete.systemExitOnSuccess|@\"`", "   call `System.exit(0)` when execution completes normally.", "* `\"@|yellow picocli.autocomplete.systemExitOnError|@\"`", "   call `System.exit(ERROR_CODE)` when an error occurs.", "", "If these system properties are not defined or have value \"false\", this program completes without terminating the JVM.", "", "Example", "-------", "  java -cp \"myapp.jar;picocli-4.5.1.jar\" \\", "              picocli.AutoComplete my.pkg.MyClass"}, exitCodeListHeading="%nExit Codes:%n", exitCodeList={"0:Successful program execution", "1:Usage error: user input for the command was incorrect, e.g., the wrong number of arguments, a bad flag, a bad syntax in a parameter, etc.", "2:The specified command script exists (Specify `--force` to overwrite).", "3:The specified completion script exists (Specify `--force` to overwrite).", "4:An exception occurred while generating the completion script."}, exitCodeOnInvalidInput=1, exitCodeOnExecutionException=4)
    private static class App
    implements Callable<Integer> {
        @CommandLine.Parameters(arity="1", description={"Fully qualified class name of the annotated `@Command` class to generate a completion script for."})
        String commandLineFQCN;
        @CommandLine.Option(names={"-c", "--factory"}, description={"Optionally specify the fully qualified class name of the custom factory to use to instantiate the command class. When omitted, the default picocli factory is used."})
        String factoryClass;
        @CommandLine.Option(names={"-n", "--name"}, description={"Optionally specify the name of the command to create a completion script for. When omitted, the annotated class `@Command(name = \"...\")` attribute is used. If no `@Command(name = ...)` attribute exists, '<CLASS-SIMPLE-NAME>' (in lower-case) is used."})
        String commandName;
        @CommandLine.Option(names={"-o", "--completionScript"}, description={"Optionally specify the path of the completion script file to generate. When omitted, a file named '<commandName>_completion' is generated in the current directory."})
        File autoCompleteScript;
        @CommandLine.Option(names={"-w", "--writeCommandScript"}, description={"Write a '<commandName>' sample command script to the same directory as the completion script."})
        boolean writeCommandScript;
        @CommandLine.Option(names={"-f", "--force"}, description={"Overwrite existing script files."})
        boolean overwriteIfExists;
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;

        private App() {
        }

        @Override
        public Integer call() throws Exception {
            CommandLine.IFactory iFactory = CommandLine.defaultFactory();
            if (this.factoryClass != null) {
                iFactory = (CommandLine.IFactory)iFactory.create(Class.forName(this.factoryClass));
            }
            Class<?> clazz = Class.forName(this.commandLineFQCN);
            Object obj = iFactory.create(clazz);
            CommandLine commandLine = new CommandLine(obj, iFactory);
            if (this.commandName == null) {
                this.commandName = commandLine.getCommandName();
                if ("<main class>".equals(this.commandName)) {
                    this.commandName = clazz.getSimpleName().toLowerCase();
                }
            }
            if (this.autoCompleteScript == null) {
                this.autoCompleteScript = new File(this.commandName + "_completion");
            }
            File file = null;
            if (this.writeCommandScript) {
                file = new File(this.autoCompleteScript.getAbsoluteFile().getParentFile(), this.commandName);
            }
            if (file != null && !this.overwriteIfExists && this.checkExists(file)) {
                return 2;
            }
            if (!this.overwriteIfExists) {
                App app = this;
                if (app.checkExists(app.autoCompleteScript)) {
                    return 3;
                }
            }
            AutoComplete.bash(this.commandName, this.autoCompleteScript, file, commandLine);
            return 0;
        }

        private boolean checkExists(File file) {
            if (file.exists()) {
                PrintWriter printWriter = this.spec.commandLine().getErr();
                printWriter.printf("ERROR: picocli.AutoComplete: %s exists. Specify --force to overwrite.%n", file.getAbsolutePath());
                this.spec.commandLine().usage(printWriter);
                return true;
            }
            return false;
        }
    }
}

